/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.evalidator.adapter;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.bridge.Activator;
import org.eclipse.sphinx.emf.validation.bridge.extensions.RulesExtCache;
import org.eclipse.sphinx.emf.validation.bridge.extensions.RulesExtInternal;
import org.eclipse.sphinx.emf.validation.evalidator.adapter.EValidatorAdapter;
import org.eclipse.sphinx.emf.validation.util.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class EValidatorRegistering {
    private EValidator.Registry eValidatorRegistry = EValidator.Registry.INSTANCE;
    private static EValidatorRegistering singleton = null;

    public static EValidatorRegistering getSingleton() {
        if (singleton == null) {
            singleton = new EValidatorRegistering();
        }
        return singleton;
    }

    private EValidatorRegistering() {
    }

    public void eValidatorSetAllContributions(String pluginID) {
        IExtension[] exts;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint pt = reg.getExtensionPoint("org.eclipse.sphinx.emf.validation.registration");
        IExtension[] iExtensionArray = exts = pt.getExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getContributor().getName().equals(pluginID)) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement confElement = iConfigurationElementArray[n4];
                    this.eValidatorSetting(confElement.getAttribute("id"));
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void eValidatorSetting(String modelId) {
        HashMap extRuleCacheMap;
        RulesExtInternal r;
        if (!this.eValidatorRegistry.containsKey((Object)modelId) && (r = (RulesExtInternal)(extRuleCacheMap = RulesExtCache.getSingleton().getRulesExtInternals()).get(modelId)) != null) {
            EClass eClass = r.getRootModelClass();
            if (eClass == null) {
                return;
            }
            EPackage targetPackage = eClass.getEPackage();
            if (targetPackage == null) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)NLS.bind((String)Messages.__EValidatorRegstering_NoSuchPackage, (Object[])new Object[]{r.getNsURI(), r.getModelId()}));
            } else {
                Object validatorAdapter = r.getValidatorAdapter();
                if (validatorAdapter == null) {
                    validatorAdapter = new EValidatorAdapter();
                }
                EValidator.Registry.INSTANCE.put((Object)r.getRootModelClass().getEPackage(), validatorAdapter);
            }
        }
    }
}

