/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.wizards.pages;

import java.util.MissingResourceException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sphinx.platform.ui.fields.Separator;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractWizardPage
extends WizardPage
implements IWizardPage {
    protected AbstractWizardPage(String pageName) {
        super(pageName);
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    public final void createControl(Composite parent) {
        Control control = this.doCreateControl(parent);
        this.setControl(control);
    }

    public final boolean isPageComplete() {
        return this.doIsPageComplete();
    }

    protected abstract Control doCreateControl(Composite var1);

    protected abstract String doGetDescription() throws MissingResourceException;

    private String getPageDescription() {
        String description = "";
        try {
            description = this.doGetDescription();
        }
        catch (MissingResourceException e) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)e);
        }
        return description;
    }

    protected abstract String doGetTitle() throws MissingResourceException;

    private String getPageTitle() {
        String title = "";
        try {
            title = this.doGetTitle();
        }
        catch (MissingResourceException e) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)e);
        }
        return title;
    }

    protected abstract boolean doIsPageComplete();

    protected abstract IStatus doValidateRules();

    protected final void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.setMessage(null);
                break;
            }
            case 1: {
                this.setMessage(status.getMessage(), 1);
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 4: {
                this.setMessage(status.getMessage(), 3);
                break;
            }
        }
    }

    protected final IStatus validateRules() {
        return this.doValidateRules();
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected final void createSeparator(Composite composite, int nbCol) {
        new Separator(258).fillIntoGrid(composite, nbCol, this.convertHeightInCharsToPixels(1));
    }

    public void finish() {
    }
}

