/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager.steps;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.channelmanager.OpenChannelException;
import org.eclipse.tcf.te.tcf.core.events.ChannelEvent;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;

public class ChainPeerStep
extends AbstractPeerStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)callback);
        final AtomicReference<IChannel> channel = new AtomicReference<IChannel>((IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data));
        final IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        final String logname = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.tcf.locator.logname", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IChannel c = (IChannel)channel.get();
                if (c == null) {
                    c = peer.openChannel();
                    channel.set(c);
                    String message = "to " + peer.getID();
                    PropertiesContainer eventData = new PropertiesContainer();
                    eventData.setProperty("message", (Object)message);
                    eventData.setProperty("logname", (Object)logname);
                    ChannelEvent event = new ChannelEvent((Object)ChainPeerStep.this, c, "opening", (IPropertiesContainer)eventData);
                    EventManager.getInstance().fireEvent((EventObject)event);
                } else {
                    String id = String.valueOf((String)peer.getAttributes().get("TransportName")) + ":" + (String)peer.getAttributes().get("Host") + ":" + (String)peer.getAttributes().get("Port");
                    id = id.equalsIgnoreCase(peer.getID()) ? peer.getID() : String.valueOf(id) + " (" + peer.getID() + ")";
                    String message = String.valueOf(c.getRemotePeer().getID()) + " --> " + id;
                    PropertiesContainer eventData = new PropertiesContainer();
                    eventData.setProperty("message", (Object)message);
                    eventData.setProperty("logname", (Object)logname);
                    ChannelEvent event = new ChannelEvent((Object)ChainPeerStep.this, c, "redirect", (IPropertiesContainer)eventData);
                    EventManager.getInstance().fireEvent((EventObject)event);
                    c.redirect(peer.getAttributes());
                }
                Assert.isNotNull((Object)c);
                Assert.isTrue((boolean)c.equals(channel.get()));
                c.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        ((IChannel)channel.get()).removeChannelListener((IChannel.IChannelListener)this);
                        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, channel.get(), (boolean)true);
                        ChainPeerStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                    }

                    public void onChannelClosed(Throwable error) {
                        ((IChannel)channel.get()).removeChannelListener((IChannel.IChannelListener)this);
                        if (error != null) {
                            error = new OpenChannelException(error);
                        }
                        ChainPeerStep.this.callback(data, fullQualifiedId, callback, StatusHelper.getStatus((Throwable)error), null);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    public void rollback(final IStepContext context, final IPropertiesContainer data, final IStatus status, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        final IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel != null && channel.getState() != 2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    channel.close();
                    ChainPeerStep.super.rollback(context, data, status, fullQualifiedId, monitor, callback);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeLater((Runnable)runnable);
            }
        } else {
            super.rollback(context, data, status, fullQualifiedId, monitor, callback);
        }
    }

    public int getCancelTimeout() {
        return 500;
    }
}

