/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.OutgoingChangesDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;

public abstract class ReplaceWithTagAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        final ReplaceOperation replaceOperation = this.createReplaceOperation();
        if (this.hasOutgoingChanges(replaceOperation)) {
            final boolean[] keepGoing = new boolean[]{true};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OutgoingChangesDialog dialog = new OutgoingChangesDialog(ReplaceWithTagAction.this.getShell(), replaceOperation.getScopeManager(), CVSUIMessages.ReplaceWithTagAction_2, CVSUIMessages.ReplaceWithTagAction_0, CVSUIMessages.ReplaceWithTagAction_1);
                    dialog.setHelpContextId("org.eclipse.team.cvs.ui.replace_outgoing_changes_dialog_context");
                    int result = dialog.open();
                    keepGoing[0] = result == 0;
                }
            });
            if (!keepGoing[0]) {
                return;
            }
        }
        final CVSTag[] tag = new CVSTag[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                monitor = Policy.monitorFor(monitor);
                tag[0] = ReplaceWithTagAction.this.getTag(replaceOperation);
                if (tag[0] == null) {
                    return;
                }
                try {
                    if (!CVSAction.checkForMixingTags(ReplaceWithTagAction.this.getShell(), replaceOperation.getScope().getRoots(), tag[0])) {
                        tag[0] = null;
                        return;
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, false, 2);
        if (tag[0] == null) {
            return;
        }
        replaceOperation.setTag(tag[0]);
        replaceOperation.run();
    }

    protected ReplaceOperation createReplaceOperation() {
        return new ReplaceOperation(this.getTargetPart(), this.getCVSResourceMappings(), null);
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.ReplaceWithTagAction_replace;
    }

    @Override
    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    protected abstract CVSTag getTag(ReplaceOperation var1);
}

