/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.panel.remote.ComparePanel;

public class CompareAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IRepositoryResource first = this.getSelectedRepositoryResources()[0];
        ComparePanel panel = new ComparePanel(first);
        panel.setFilterCurrent(true);
        DefaultDialog dlg = new DefaultDialog(this.getShell(), panel);
        if (dlg.open() == 0) {
            this.doCompare(first, panel.getSelectedResource(), panel.getDiffOptions());
        }
    }

    public boolean isEnabled() {
        boolean isCompareFoldersAllowed;
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length != 1) {
            return false;
        }
        boolean bl = isCompareFoldersAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5;
        return isCompareFoldersAllowed || resources[0] instanceof IRepositoryFile;
    }

    protected void doCompare(IRepositoryResource first, IRepositoryResource second, long options) {
        try {
            if (second.getRevision() > first.getRevision()) {
                IRepositoryResource tmp = second;
                second = first;
                first = tmp;
            }
        }
        catch (SVNConnectorException ex) {
            UILoggedOperation.reportError("Compare", ex);
        }
        this.runScheduled((IActionOperation)new CompareRepositoryResourcesOperation(second, first, false, options));
    }
}

