/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlamegraphDepthEntry;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.ThreadIdComparator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.ThreadNameComparator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class FlameGraphContentProvider
implements ITimeGraphContentProvider {
    private final List<FlamegraphDepthEntry> fFlameGraphEntries = new ArrayList<FlamegraphDepthEntry>();
    private SortOption fSortOption = SortOption.BY_NAME;
    private @NonNull Comparator<FlamegraphDepthEntry> fThreadComparator = new ThreadNameComparator();

    private void setData(AggregatedCalledFunction firstNode, List<FlamegraphDepthEntry> childrenEntries, Deque<Long> timestampStack) {
        long lastEnd = timestampStack.peek();
        int i = 0;
        while (i < firstNode.getMaxDepth()) {
            if (i >= childrenEntries.size()) {
                FlamegraphDepthEntry entry = new FlamegraphDepthEntry(String.valueOf(i), 0L, firstNode.getDuration(), i, i);
                childrenEntries.add(entry);
            }
            childrenEntries.get(i).updateEndTime(lastEnd + firstNode.getDuration());
            ++i;
        }
        FlamegraphDepthEntry firstEntry = (FlamegraphDepthEntry)((Object)NonNullUtils.checkNotNull((Object)((Object)childrenEntries.get(0))));
        firstEntry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)firstEntry, lastEnd, firstNode));
        this.addEvent(firstNode, childrenEntries, timestampStack);
        timestampStack.pop();
    }

    private void addEvent(AggregatedCalledFunction node, List<FlamegraphDepthEntry> childrenEntries, Deque<Long> timestampStack) {
        if (node.hasChildren().booleanValue()) {
            node.getChildren().stream().sorted(Comparator.comparingLong(AggregatedCalledFunction::getDuration)).forEach(child -> this.addEvent((AggregatedCalledFunction)child, childrenEntries, timestampStack));
            node.getChildren().stream().forEach(child -> timestampStack.pop());
        }
        FlamegraphDepthEntry entry = (FlamegraphDepthEntry)((Object)NonNullUtils.checkNotNull((Object)((Object)childrenEntries.get(node.getDepth()))));
        entry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)entry, timestampStack.peek(), node));
        timestampStack.push(timestampStack.peek() + node.getDuration());
    }

    public boolean hasChildren(Object element) {
        return !this.fFlameGraphEntries.isEmpty();
    }

    public ITimeGraphEntry[] getElements(Object inputElement) {
        this.fFlameGraphEntries.clear();
        if (inputElement instanceof Collection) {
            Collection threadNodes = (Collection)inputElement;
            for (Object object : threadNodes) {
                if (!(object instanceof ThreadNode)) continue;
                this.buildChildrenEntries((ThreadNode)object);
            }
        } else {
            return new ITimeGraphEntry[0];
        }
        this.fFlameGraphEntries.sort(this.fThreadComparator);
        return this.fFlameGraphEntries.toArray(new ITimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    private void buildChildrenEntries(ThreadNode threadNode) {
        FlamegraphDepthEntry threadEntry = new FlamegraphDepthEntry("", 0L, 0L, this.fFlameGraphEntries.size(), threadNode.getId());
        ArrayList childrenEntries = new ArrayList();
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        threadNode.getChildren().stream().sorted(Comparator.comparingLong(AggregatedCalledFunction::getDuration)).forEach(rootFunction -> {
            this.setData((AggregatedCalledFunction)rootFunction, childrenEntries, (Deque<Long>)timestampStack);
            long currentThreadDuration = (Long)timestampStack.pop() + rootFunction.getDuration();
            timestampStack.push(currentThreadDuration);
        });
        childrenEntries.forEach(child -> {
            if (child != null) {
                threadEntry.addChild((TimeGraphEntry)child);
            }
        });
        threadEntry.updateEndTime((Long)timestampStack.pop());
        threadEntry.setName(threadNode.getSymbol().toString());
        this.fFlameGraphEntries.add(threadEntry);
    }

    public ITimeGraphEntry[] getChildren(Object parentElement) {
        return (ITimeGraphEntry[])this.fFlameGraphEntries.toArray(new TimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    public ITimeGraphEntry getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public SortOption getSortOption() {
        return this.fSortOption;
    }

    public void setSortOption(SortOption sortOption) {
        this.fSortOption = sortOption;
        switch (sortOption) {
            case BY_NAME: {
                this.fThreadComparator = new ThreadNameComparator();
                break;
            }
            case BY_NAME_REV: {
                this.fThreadComparator = (Comparator)NonNullUtils.checkNotNull(new ThreadNameComparator().reversed());
                break;
            }
            case BY_ID: {
                this.fThreadComparator = new ThreadIdComparator();
                break;
            }
            case BY_ID_REV: {
                this.fThreadComparator = (Comparator)NonNullUtils.checkNotNull(new ThreadIdComparator().reversed());
                break;
            }
        }
    }
}

