/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.LoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.TraceInfo;

public class DomainInfo
extends TraceInfo
implements IDomainInfo {
    private final List<IChannelInfo> fChannels = new ArrayList<IChannelInfo>();
    private List<ILoggerInfo> fLoggers = new ArrayList<ILoggerInfo>();
    private TraceDomainType fDomain = TraceDomainType.UST;
    private BufferType fBufferType = BufferType.BUFFER_TYPE_UNKNOWN;

    public DomainInfo(String name) {
        super(name);
    }

    public DomainInfo(DomainInfo other) {
        super(other);
        int i = 0;
        while (i < other.fChannels.size()) {
            if (other.fChannels.get(i) instanceof ChannelInfo) {
                this.fChannels.add(new ChannelInfo((ChannelInfo)other.fChannels.get(i)));
            } else {
                this.fChannels.add(other.fChannels.get(i));
            }
            ++i;
        }
        for (ILoggerInfo loggerInfo : other.fLoggers) {
            if (loggerInfo instanceof LoggerInfo) {
                this.fLoggers.add(new LoggerInfo((LoggerInfo)loggerInfo));
                continue;
            }
            this.fLoggers.add(loggerInfo);
        }
        this.fDomain = other.getDomain();
        this.fBufferType = other.fBufferType;
    }

    @Override
    public TraceDomainType getDomain() {
        return this.fDomain;
    }

    @Override
    public void setDomain(TraceDomainType domain) {
        this.fDomain = domain;
    }

    @Override
    public IChannelInfo[] getChannels() {
        return this.fChannels.toArray(new IChannelInfo[this.fChannels.size()]);
    }

    @Override
    public void setChannels(List<IChannelInfo> channels) {
        this.fChannels.clear();
        for (IChannelInfo channelInfo : channels) {
            this.fChannels.add(channelInfo);
        }
    }

    @Override
    public void addChannel(IChannelInfo channel) {
        this.fChannels.add(channel);
    }

    @Override
    public List<ILoggerInfo> getLoggers() {
        return new ArrayList<ILoggerInfo>(this.fLoggers);
    }

    @Override
    public void setLoggers(List<ILoggerInfo> loggers) {
        this.fLoggers.clear();
        for (ILoggerInfo logger : loggers) {
            this.fLoggers.add(logger);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fChannels.hashCode();
        result = 31 * result + this.fLoggers.hashCode();
        result = 31 * result + (this.fDomain == null ? 0 : this.fDomain.ordinal() + 1);
        result = 31 * result + (this.fBufferType == null ? 0 : this.fBufferType.ordinal() + 1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainInfo other = (DomainInfo)obj;
        if (!this.fChannels.equals(other.fChannels)) {
            return false;
        }
        if (!this.fLoggers.equals(other.fLoggers)) {
            return false;
        }
        if (this.fDomain == null ? other.fDomain != null : !this.fDomain.equals((Object)other.fDomain)) {
            return false;
        }
        return this.fBufferType == other.fBufferType;
    }

    @Override
    public BufferType getBufferType() {
        if (this.fDomain.equals((Object)TraceDomainType.KERNEL)) {
            return BufferType.BUFFER_SHARED;
        }
        return this.fBufferType;
    }

    @Override
    public void setBufferType(BufferType bufferType) {
        this.fBufferType = bufferType;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[DomainInfo(");
        output.append(super.toString());
        output.append(",Channels=");
        if (this.fChannels.isEmpty()) {
            output.append("None");
        } else {
            for (IChannelInfo channel : this.fChannels) {
                output.append(channel.toString());
            }
        }
        output.append(",Loggers=");
        if (this.fLoggers.isEmpty()) {
            output.append("None");
        } else {
            for (ILoggerInfo logger : this.fLoggers) {
                output.append(logger.toString());
            }
        }
        output.append(",isKernel=");
        output.append(String.valueOf(this.fDomain.equals((Object)TraceDomainType.KERNEL)));
        if (this.fBufferType != null && !this.fBufferType.equals((Object)BufferType.BUFFER_TYPE_UNKNOWN) && !this.fBufferType.equals((Object)BufferType.BUFFER_SHARED)) {
            output.append(",BufferType=");
            output.append((Object)this.fBufferType);
        }
        output.append(")]");
        return output.toString();
    }
}

