/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public interface ITimeGraphPresentationProvider {
    public static final int INVISIBLE = -1;
    public static final int TRANSPARENT = -2;

    public String getStateTypeName();

    public String getStateTypeName(ITimeGraphEntry var1);

    public StateItem[] getStateTable();

    public int getStateTableIndex(ITimeEvent var1);

    public void postDrawControl(Rectangle var1, GC var2);

    public void postDrawEntry(ITimeGraphEntry var1, Rectangle var2, GC var3);

    public void postDrawEvent(ITimeEvent var1, Rectangle var2, GC var3);

    public int getItemHeight(ITimeGraphEntry var1);

    public Image getItemImage(ITimeGraphEntry var1);

    public String getEventName(ITimeEvent var1);

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1);

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1, long var2);

    public boolean displayTimesInTooltip();

    default public Map<String, Object> getEventStyle(ITimeEvent event) {
        StateItem stateItem = null;
        int index = this.getStateTableIndex(event);
        StateItem[] stateTable = this.getStateTable();
        if (index >= 0 && index < stateTable.length) {
            stateItem = stateTable[index];
        }
        Map<String, Object> styleMap = stateItem == null ? Collections.EMPTY_MAP : stateItem.getStyleMap();
        Map<String, Object> specificEventStyles = this.getSpecificEventStyle(event);
        if (specificEventStyles.isEmpty()) {
            return styleMap;
        }
        if (styleMap.isEmpty()) {
            return specificEventStyles;
        }
        styleMap = new HashMap<String, Object>(styleMap);
        styleMap.putAll(specificEventStyles);
        return styleMap;
    }

    default public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        return Collections.emptyMap();
    }
}

