/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.construction.plancompiler;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.rete.construction.plancompiler.CompilerHelper;
import org.eclipse.viatra.query.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.viatra.query.runtime.rete.traceability.CompiledQuery;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

public class RecursionCutoffPoint {
    final RecipeTraceInfo.ParentTraceList futureTraceList;
    final Map<PBody, RecipeTraceInfo> futureTraceMap;
    final CompiledQuery compiledQuery;
    final ProductionRecipe recipe;
    final QueryEvaluationHint hint;

    public RecursionCutoffPoint(PQuery query, QueryEvaluationHint hint, IQueryMetaContext context) {
        this.hint = hint;
        this.futureTraceList = new RecipeTraceInfo.ParentTraceList();
        this.futureTraceMap = new HashMap<PBody, RecipeTraceInfo>();
        this.compiledQuery = CompilerHelper.makeQueryTrace(query, this.futureTraceMap, Collections.emptySet(), hint, context);
        this.recipe = (ProductionRecipe)this.compiledQuery.getRecipe();
        Preconditions.checkArgument((boolean)this.compiledQuery.getParentRecipeTraces().isEmpty(), (Object)String.format("Recursion cut-off point of query %s has trace parents: %s", this.compiledQuery.getQuery(), Joiner.on((String)", ").join(this.compiledQuery.getParentRecipeTraces())));
        Preconditions.checkArgument((boolean)this.recipe.getParents().isEmpty(), (Object)String.format("Recursion cut-off point of query %s has recipe parents: %s", this.compiledQuery.getQuery(), Joiner.on((String)", ").join(this.compiledQuery.getParentRecipeTraces())));
    }

    public void mend(CompiledQuery finalCompiledForm) {
        this.futureTraceList.addAll(finalCompiledForm.getParentRecipeTraces());
        this.futureTraceMap.putAll(finalCompiledForm.getParentRecipeTracesPerBody());
        this.recipe.getParents().addAll((Collection)((ProductionRecipe)finalCompiledForm.getRecipe()).getParents());
    }

    public CompiledQuery getCompiledQuery() {
        return this.compiledQuery;
    }

    public ProductionRecipe getRecipe() {
        return this.recipe;
    }
}

