/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.SubtypesScope;
import org.eclipse.wb.internal.core.utils.ui.MenuManagerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMorphingSupport<T extends ObjectInfo> {
    protected final String m_toolkitClassName;
    protected final T m_component;

    protected AbstractMorphingSupport(String toolkitClassName, T component) {
        this.m_toolkitClassName = toolkitClassName;
        this.m_component = component;
    }

    protected abstract IJavaProject getJavaProject();

    protected abstract ClassLoader getClassLoader();

    protected abstract Class<?> getComponentClass();

    protected abstract List<MorphingTargetDescription> getMorphingTargets();

    protected static MenuManagerEx createMorphManager(IContributionManager manager) {
        MenuManagerEx morphManager = new MenuManagerEx(ModelMessages.MorphingSupport_managerText);
        morphManager.setImage(DesignerPlugin.getImage((String)"actions/morph/morph2.png"));
        manager.appendToGroup("org.eclipse.wb.popup.group.inheritance", (IContributionItem)morphManager);
        return morphManager;
    }

    public static <T extends ObjectInfo> void contribute(AbstractMorphingSupport<T> morphingSupport, IContributionManager manager) throws Exception {
        MenuManagerEx morphManager = AbstractMorphingSupport.createMorphManager(manager);
        for (MorphingTargetDescription target : morphingSupport.getMorphingTargets()) {
            AbstractMorphingSupport<T> abstractMorphingSupport = morphingSupport;
            abstractMorphingSupport.getClass();
            morphManager.add((IAction)abstractMorphingSupport.new MorphTargetAction(target));
        }
        morphManager.add((IContributionItem)new Separator());
        String baseClassName = morphingSupport.getComponentClass().getName();
        AbstractMorphingSupport<T> abstractMorphingSupport = morphingSupport;
        abstractMorphingSupport.getClass();
        MorphSubclassAction action = abstractMorphingSupport.new MorphSubclassAction(baseClassName);
        action.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"actions/morph/subclass.gif"));
        action.setText(ModelMessages.MorphingSupport_subclassAction);
        morphManager.add((IAction)action);
        AbstractMorphingSupport<T> abstractMorphingSupport2 = morphingSupport;
        abstractMorphingSupport2.getClass();
        MorphSubclassAction action2 = abstractMorphingSupport2.new MorphSubclassAction(morphingSupport.m_toolkitClassName);
        action2.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"actions/morph/other.gif"));
        action2.setText(ModelMessages.MorphingSupport_otherAction);
        morphManager.add((IAction)action2);
    }

    protected String validate(MorphingTargetDescription target) throws Exception {
        return null;
    }

    protected void morph(MorphingTargetDescription target) throws Exception {
        T newComponent = this.morph_create(target);
        this.morph_replace(newComponent);
        this.morph_properties(newComponent);
        this.morph_children(newComponent);
        this.morph_source(newComponent);
        this.morph_finish(newComponent);
    }

    protected abstract T morph_create(MorphingTargetDescription var1) throws Exception;

    protected abstract void morph_replace(T var1) throws Exception;

    protected abstract void morph_properties(T var1) throws Exception;

    protected abstract void morph_children(T var1) throws Exception;

    protected abstract void morph_source(T var1) throws Exception;

    protected abstract void morph_finish(T var1) throws Exception;

    protected abstract ImageDescriptor getTargetImageDescriptor(MorphingTargetDescription var1) throws Exception;

    protected abstract String getTargetText(MorphingTargetDescription var1) throws Exception;

    protected abstract class MorphAction
    extends Action {
        protected MorphAction() {
        }

        public final int hashCode() {
            return 0;
        }

        public final boolean equals(Object obj) {
            return obj instanceof MorphTargetAction;
        }

        public final void run() {
            MorphingTargetDescription target;
            try {
                target = this.getTarget();
                if (target == null) {
                    return;
                }
                String message = AbstractMorphingSupport.this.validate(target);
                if (message != null) {
                    MessageDialog.openError((Shell)DesignerPlugin.getShell(), (String)ModelMessages.MorphingSupport_incompatibleTargetTitle, (String)message);
                    return;
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
                return;
            }
            RunnableEx runnable = new RunnableEx(){

                public void run() throws Exception {
                    AbstractMorphingSupport.this.morph(target);
                }
            };
            ObjectInfo rootObject = AbstractMorphingSupport.this.m_component.getRoot();
            if (AbstractMorphingSupport.this.m_component != rootObject) {
                ExecutionUtils.run((ObjectInfo)rootObject, (RunnableEx)runnable);
            } else {
                ExecutionUtils.runLog((RunnableEx)runnable);
            }
        }

        protected abstract MorphingTargetDescription getTarget() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MorphSubclassAction
    extends MorphAction {
        private final String m_baseClassName;

        public MorphSubclassAction(String baseClassName) {
            this.m_baseClassName = baseClassName;
        }

        @Override
        protected MorphingTargetDescription getTarget() throws Exception {
            IJavaProject project = AbstractMorphingSupport.this.getJavaProject();
            IType componentType = project.findType(this.m_baseClassName);
            SubtypesScope scope = new SubtypesScope(componentType);
            Shell shell = DesignerPlugin.getShell();
            ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)scope, (int)2, (boolean)false);
            dialog.setTitle(ModelMessages.MorphingSupport_chooseTitle);
            dialog.setMessage(ModelMessages.MorphingSupport_chooseMessage);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                String typeName = type.getFullyQualifiedName();
                Class<?> targetClass = AbstractMorphingSupport.this.getClassLoader().loadClass(typeName);
                return new MorphingTargetDescription(targetClass, null);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MorphTargetAction
    extends MorphAction {
        private final MorphingTargetDescription m_target;

        public MorphTargetAction(MorphingTargetDescription target) throws Exception {
            this.m_target = target;
            this.setImageDescriptor(AbstractMorphingSupport.this.getTargetImageDescriptor(target));
            this.setText(AbstractMorphingSupport.this.getTargetText(target));
        }

        @Override
        protected MorphingTargetDescription getTarget() throws Exception {
            return this.m_target;
        }
    }
}

