/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.SelectionRequest;
import org.eclipse.wb.gef.core.tools.TargetingTool;

public class SelectEditPartTracker
extends TargetingTool {
    private final EditPart m_sourceEditPart;
    private boolean m_isSelected;

    public SelectEditPartTracker(EditPart sourceEditPart) {
        this.m_sourceEditPart = sourceEditPart;
    }

    protected void resetState() {
        super.resetState();
        this.m_isSelected = false;
    }

    protected Cursor calculateCursor() {
        return this.m_state == 1 || this.m_state == 2 ? this.getDefaultCursor() : super.calculateCursor();
    }

    protected void handleButtonDown(int button) {
        if ((button == 1 || button == 3) && this.m_state == 1 && this.m_sourceEditPart.getSelected() == 0) {
            this.performSelection();
        }
        if (button == 1) {
            if (this.m_state == 1) {
                this.m_state = 2;
            }
        } else {
            this.m_state = button == 3 ? 0 : 4;
            this.handleInvalidInput();
        }
    }

    protected void handleButtonUp(int button) {
        if (this.m_state == 2) {
            this.performSelection();
            this.performClick();
            this.m_state = 0;
        }
    }

    protected void handleDragStarted() {
        if (this.m_state == 2) {
            this.m_state = 3;
        }
    }

    protected void handleDoubleClick(int button) {
        if (button == 1) {
            SelectionRequest request = new SelectionRequest("open");
            request.setLocation(this.getLocation());
            this.m_sourceEditPart.performRequest(request);
        }
    }

    private void performSelection() {
        if (!this.m_isSelected) {
            this.m_isSelected = true;
            IEditPartViewer viewer = this.getViewer();
            if ((this.m_stateMask & 0x40000) != 0) {
                if (viewer.getSelectedEditParts().contains(this.m_sourceEditPart)) {
                    viewer.deselect(this.m_sourceEditPart);
                } else {
                    viewer.appendSelection(this.m_sourceEditPart);
                }
            } else if ((this.m_stateMask & 0x20000) != 0) {
                viewer.appendSelection(this.m_sourceEditPart);
            } else {
                viewer.select(this.m_sourceEditPart);
            }
        }
    }

    private void performClick() {
        if (this.m_sourceEditPart.getSelected() != 0) {
            this.getViewer().fireEditPartClick(this.m_sourceEditPart);
        }
    }
}

