/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Version
implements Comparable<Version> {
    private final List<Integer> components;
    private final String textComponent;

    public Version(Integer ... components) {
        this(Arrays.asList(components), null);
    }

    public Version(List<Integer> components, String textComponent) {
        this.components = Collections.unmodifiableList(new ArrayList<Integer>(components));
        this.textComponent = textComponent;
    }

    public List<Integer> getComponents() {
        return this.components;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Version)) {
            return false;
        }
        Version that = (Version)obj;
        return this.components.equals(that.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    @Override
    public int compareTo(Version other) {
        int i = 0;
        while (i < this.components.size()) {
            if (other.components.size() <= i) {
                return 1;
            }
            int res = this.components.get(i).compareTo(other.components.get(i));
            if (res != 0) {
                return res;
            }
            ++i;
        }
        if (this.components.size() < other.components.size()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this.textComponent == null) {
            return this.components.toString();
        }
        return String.valueOf(this.components.toString()) + this.textComponent;
    }

    public static Version parseString(String text) {
        int i = 0;
        ArrayList<Integer> components = new ArrayList<Integer>(4);
        while (i < text.length()) {
            int num = Character.digit(text.charAt(i), 10);
            if (num < 0) break;
            ++i;
            while (i < text.length() && Character.digit(text.charAt(i), 10) >= 0) {
                num = num * 10 + Character.digit(text.charAt(i), 10);
                ++i;
            }
            components.add(num);
            if (i >= text.length() || text.charAt(i) != '.') break;
            ++i;
        }
        String suffix = i < text.length() ? text.substring(i) : null;
        if (components.isEmpty()) {
            return null;
        }
        return new Version(components, suffix);
    }
}

