/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.Endpoint;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.InvokeWSDLOperationTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.util.SOAPMessageUtils;
import org.eclipse.wst.ws.internal.explorer.transport.HTTPTransportException;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPMessage;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPTransportProvider;
import org.eclipse.wst.ws.internal.explorer.transport.TransportException;

public abstract class InvokeWSDLSOAPOperationAction
extends WSDLPropertiesFormAction {
    public InvokeWSDLSOAPOperationAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParsedResults(parser);
        String endPoint = parser.getParameter("::endPoint");
        InvokeWSDLOperationTool invokeWSDLOperationTool = (InvokeWSDLOperationTool)this.getSelectedNavigatorNode().getCurrentToolManager().getSelectedTool();
        invokeWSDLOperationTool.setEndPoint(endPoint);
        return true;
    }

    protected ISOAPMessage getSOAPRequestMessage(WSDLOperationElement operElement) {
        ISOAPTransportProvider provider = operElement.getSOAPTransportProvider();
        if (provider == null) {
            return null;
        }
        return provider.newTransport().newMessage(operElement.getMessageContext());
    }

    protected void setHeaderContent(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement, ISOAPMessage soapMessage) throws ParserConfigurationException {
        SOAPMessageUtils.setHeaderContentFromModel(soapEnvelopeNamespaceTable, operElement, soapMessage);
    }

    protected void setBodyContent(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement, ISOAPMessage soapMessage) throws ParserConfigurationException {
        SOAPMessageUtils.setBodyContentFromModel(soapEnvelopeNamespaceTable, operElement, soapMessage);
    }

    public boolean run() {
        WSDLBindingElement bindingElement;
        MessageQueue messageQueue;
        WSDLPerspective wsdlPerspective;
        String soapAddressLocation;
        block6: {
            soapAddressLocation = (String)this.propertyTable_.get("::endPoint");
            wsdlPerspective = this.controller_.getWSDLPerspective();
            messageQueue = wsdlPerspective.getMessageQueue();
            WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
            bindingElement = (WSDLBindingElement)operElement.getParentElement();
            operElement.setPropertyAsObject("soapResponseCached", new Boolean(false));
            ISOAPMessage soapMessage = this.getSOAPRequestMessage(operElement);
            if (soapMessage == null) {
                throw new TransportException(wsdlPerspective.getMessage("MSG_ERROR_NO_SUITABLE_TRANSPORT"));
            }
            Hashtable namespaceTable = new Hashtable(soapMessage.getNamespaceTable());
            this.setHeaderContent(namespaceTable, operElement, soapMessage);
            this.setBodyContent(namespaceTable, operElement, soapMessage);
            soapMessage.setNamespaceTable(namespaceTable);
            operElement.setPropertyAsObject("propSOAPRequest", soapMessage);
            if (soapAddressLocation == null) break block6;
            soapMessage.setProperty("prop_soap_action", operElement.getSoapAction());
            String[] authParams = this.retrieveAuthParams(bindingElement, soapAddressLocation);
            ISOAPMessage soapResponse = operElement.getSOAPTransportProvider().newTransport().send(soapAddressLocation, authParams[0], authParams[1], soapMessage);
            operElement.setPropertyAsObject("propSOAPResponse", soapResponse);
            wsdlPerspective.setOperationNode(this.getSelectedNavigatorNode());
            return true;
        }
        try {
            throw new IOException(wsdlPerspective.getMessage("MSG_ERROR_UNABLE_TO_CONNECT", soapAddressLocation));
        }
        catch (HTTPTransportException e) {
            this.throwHTTPTransportException(bindingElement, soapAddressLocation, e);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof TransportException && e.getCause() != null) {
                t = e.getCause();
            }
            this.handleUnexpectedException(wsdlPerspective, messageQueue, t.getClass().getName(), t);
        }
        return false;
    }

    private void throwHTTPTransportException(WSDLBindingElement bindingElement, String endpointString, HTTPTransportException httpTransportException) throws HTTPTransportException {
        Endpoint endpoint;
        if (httpTransportException.getStatusCode() == 401 && (endpoint = bindingElement.getEndpoint(endpointString)) != null) {
            endpoint.setRequireHTTPBasicAuth(true);
            endpoint.setHttpBasicAuthUsername(null);
            endpoint.setHttpBasicAuthPassword(null);
        }
        throw httpTransportException;
    }

    private String[] retrieveAuthParams(WSDLBindingElement bindingElement, String endpointString) {
        String[] authParams = new String[2];
        Endpoint endpoint = bindingElement.getEndpoint(endpointString);
        if (endpoint != null && endpoint.isRequireHTTPBasicAuth()) {
            String httpBasicAuthUsername = endpoint.getHttpBasicAuthUsername();
            String httpBasicAuthPassword = endpoint.getHttpBasicAuthPassword();
            if (httpBasicAuthUsername == null || httpBasicAuthPassword == null) {
                httpBasicAuthUsername = (String)this.propertyTable_.get("httpBasicAuthUsername");
                httpBasicAuthPassword = (String)this.propertyTable_.get("httpBasicAuthPassword");
                endpoint.setHttpBasicAuthUsername(httpBasicAuthUsername);
                endpoint.setHttpBasicAuthPassword(httpBasicAuthPassword);
            }
            if (httpBasicAuthUsername != null && httpBasicAuthPassword != null) {
                authParams[0] = httpBasicAuthUsername;
                authParams[1] = httpBasicAuthPassword;
            }
        }
        return authParams;
    }
}

