/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.macro;

import com.google.common.collect.Iterables;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Log
public class JdtBasedProcessorProvider
extends ProcessorInstanceForJvmTypeProvider {
    private static final Logger LOG = Logger.getLogger(JdtBasedProcessorProvider.class);

    public Object getProcessorInstance(JvmType type) {
        try {
            ClassLoader classLoader = this.getClassLoader((EObject)type);
            Class<?> result = classLoader.loadClass(type.getIdentifier());
            return result.newInstance();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _identifier = type.getIdentifier();
                String _plus = "Problem during instantiation of " + _identifier;
                String _plus_1 = String.valueOf(_plus) + " : ";
                String _message = e.getMessage();
                String _plus_2 = String.valueOf(_plus_1) + _message;
                throw new IllegalStateException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public ClassLoader getClassLoader(EObject ctx) {
        ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter adapter_1;
        ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter adapter;
        ResourceSet _resourceSet = ctx.eResource().getResourceSet();
        XtextResourceSet rs = (XtextResourceSet)_resourceSet;
        boolean isBuilder = ResourceSetContext.get((Notifier)rs).isBuilder();
        boolean isEditor = ResourceSetContext.get((Notifier)rs).isEditor();
        if (isBuilder && (adapter = (ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter)IterableExtensions.head((Iterable)Iterables.filter((Iterable)rs.eAdapters(), ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter.class))) != null) {
            return adapter.getClassLoader();
        }
        if (isEditor && (adapter_1 = (ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter)IterableExtensions.head((Iterable)Iterables.filter((Iterable)this.getEditorResource(ctx).eAdapters(), ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter.class))) != null) {
            boolean _tripleEquals;
            ClassLoader _classLoader = adapter_1.getClassLoader();
            boolean bl = _tripleEquals = _classLoader == null;
            if (_tripleEquals) {
                this.getEditorResource(ctx).eAdapters().remove((Object)adapter_1);
            } else {
                return adapter_1.getClassLoader();
            }
        }
        Object _classpathURIContext = rs.getClasspathURIContext();
        IJavaProject project = (IJavaProject)_classpathURIContext;
        URLClassLoader classloader = this.createClassLoaderForJavaProject(project);
        if (isBuilder) {
            EList _eAdapters = rs.eAdapters();
            ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter _processorClassloaderAdapter = new ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter((ClassLoader)classloader);
            _eAdapters.add((Object)_processorClassloaderAdapter);
        }
        if (isEditor) {
            EList _eAdapters_1 = this.getEditorResource(ctx).eAdapters();
            ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter _processorClassloaderAdapter_1 = new ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter((ClassLoader)classloader);
            _eAdapters_1.add((Object)_processorClassloaderAdapter_1);
        }
        return classloader;
    }

    private Resource getEditorResource(EObject ctx) {
        return (Resource)IterableExtensions.head((Iterable)ctx.eResource().getResourceSet().getResources());
    }

    protected URLClassLoader createClassLoaderForJavaProject(IJavaProject projectToUse) {
        LinkedHashSet urls = CollectionLiterals.newLinkedHashSet((Object[])new URL[0]);
        try {
            this.collectClasspathURLs(projectToUse, urls, this.isOutputFolderIncluded(), CollectionLiterals.newHashSet((Object[])new IJavaProject[0]));
        }
        catch (Throwable _t) {
            if (_t instanceof JavaModelException) {
                boolean _not;
                JavaModelException e = (JavaModelException)_t;
                boolean _isDoesNotExist = e.isDoesNotExist();
                boolean bl = _not = !_isDoesNotExist;
                if (_not) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        ClassLoader _parentClassLoader = this.getParentClassLoader();
        return new URLClassLoader((URL[])Conversions.unwrapArray((Object)urls, URL.class), _parentClassLoader);
    }

    protected boolean isOutputFolderIncluded() {
        return false;
    }

    protected void collectClasspathURLs(IJavaProject projectToUse, LinkedHashSet<URL> result, boolean includeOutputFolder, Set<IJavaProject> visited) throws JavaModelException {
        try {
            IClasspathEntry[] resolvedClasspath;
            if (!projectToUse.getProject().isAccessible() || !visited.add(projectToUse)) {
                return;
            }
            if (includeOutputFolder) {
                IPath path = projectToUse.getOutputLocation().addTrailingSeparator();
                String _string = URI.createPlatformResourceURI((String)path.toString(), (boolean)true).toString();
                URL url = new URL(_string);
                result.add(url);
            }
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath = projectToUse.getResolvedClasspath(true);
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                URL url_1 = null;
                int _entryKind = entry.getEntryKind();
                switch (_entryKind) {
                    case 3: {
                        URL _uRL;
                        IPath path_1;
                        if (!includeOutputFolder || (path_1 = entry.getOutputLocation()) == null) break;
                        String _string_1 = URI.createPlatformResourceURI((String)path_1.addTrailingSeparator().toString(), (boolean)true).toString();
                        url_1 = _uRL = new URL(_string_1);
                        break;
                    }
                    case 2: {
                        IPath path_2 = entry.getPath();
                        IResource project = this.getWorkspaceRoot(projectToUse).findMember(path_2);
                        IJavaProject referencedProject = JavaCore.create((IProject)project.getProject());
                        this.collectClasspathURLs(referencedProject, result, true, visited);
                        break;
                    }
                    case 1: {
                        IPath path_3 = entry.getPath();
                        IResource library = this.getWorkspaceRoot(projectToUse).findMember(path_3);
                        URL _xifexpression = null;
                        _xifexpression = library != null ? library.getRawLocationURI().toURL() : path_3.toFile().toURI().toURL();
                        url_1 = _xifexpression;
                        break;
                    }
                    default: {
                        IPath path_4 = entry.getPath();
                        url_1 = path_4.toFile().toURI().toURL();
                    }
                }
                if (url_1 != null) {
                    result.add(url_1);
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ClassLoader getParentClassLoader() {
        ClassLoader bundleClassLoader = TransformationContext.class.getClassLoader();
        return bundleClassLoader;
    }

    private IWorkspaceRoot getWorkspaceRoot(IJavaProject javaProject) {
        return javaProject.getProject().getWorkspace().getRoot();
    }
}

