/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleProjectStructure;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleProjectStructure;
import java.util.Set;
import org.gradle.tooling.model.gradle.GradleBuild;

public final class DefaultOmniGradleBuild
implements OmniGradleBuild {
    private final OmniGradleProjectStructure rootProject;
    private final ImmutableSet<OmniGradleBuild> includedBuilds;

    private DefaultOmniGradleBuild(OmniGradleProjectStructure rootProject, ImmutableSet<OmniGradleBuild> includedBuilds) {
        this.rootProject = (OmniGradleProjectStructure)Preconditions.checkNotNull((Object)rootProject);
        this.includedBuilds = ImmutableSet.copyOf(includedBuilds);
    }

    @Override
    public OmniGradleProjectStructure getRootProject() {
        return this.rootProject;
    }

    @Override
    public Set<OmniGradleBuild> getIncludedBuilds() {
        return this.includedBuilds;
    }

    public static DefaultOmniGradleBuild from(GradleBuild gradleBuild) {
        DefaultOmniGradleProjectStructure rootProject = DefaultOmniGradleProjectStructure.from(gradleBuild.getRootProject());
        ImmutableSet.Builder includedBuilds = ImmutableSet.builder();
        for (GradleBuild includedBuild : gradleBuild.getIncludedBuilds()) {
            includedBuilds.add((Object)DefaultOmniGradleBuild.from(includedBuild));
        }
        return new DefaultOmniGradleBuild(rootProject, (ImmutableSet<OmniGradleBuild>)includedBuilds.build());
    }
}

