/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.resize.command;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.nattable.command.AbstractMultiRowCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.RowPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

public class MultiRowResizeCommand
extends AbstractMultiRowCommand {
    private int commonRowHeight = -1;
    protected Map<RowPositionCoordinate, Integer> rowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>();

    public MultiRowResizeCommand(ILayer layer, int[] rowPositions, int commonRowHeight) {
        super(layer, rowPositions);
        this.commonRowHeight = commonRowHeight;
    }

    public MultiRowResizeCommand(ILayer layer, int[] rowPositions, int[] rowHeights) {
        super(layer, rowPositions);
        int i = 0;
        while (i < rowPositions.length) {
            this.rowPositionToHeight.put(new RowPositionCoordinate(layer, rowPositions[i]), rowHeights[i]);
            ++i;
        }
    }

    protected MultiRowResizeCommand(MultiRowResizeCommand command) {
        super(command);
        this.commonRowHeight = command.commonRowHeight;
        this.rowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>(command.rowPositionToHeight);
    }

    public int getCommonRowHeight() {
        return this.commonRowHeight;
    }

    public int getRowHeight(int rowPosition) {
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionToHeight.keySet()) {
            if (rowPositionCoordinate.getRowPosition() != rowPosition) continue;
            return this.rowPositionToHeight.get(rowPositionCoordinate);
        }
        return this.commonRowHeight;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        HashMap<RowPositionCoordinate, Integer> newRowPositionToHeight = new HashMap<RowPositionCoordinate, Integer>();
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionToHeight.keySet()) {
            RowPositionCoordinate convertedRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(rowPositionCoordinate, targetLayer);
            if (convertedRowPositionCoordinate == null) continue;
            newRowPositionToHeight.put(convertedRowPositionCoordinate, this.rowPositionToHeight.get(rowPositionCoordinate));
        }
        this.rowPositionToHeight = newRowPositionToHeight;
        return super.convertToTargetLayer(targetLayer);
    }

    public MultiRowResizeCommand cloneCommand() {
        return new MultiRowResizeCommand(this);
    }
}

