/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml.util;

import org.eclipse.birt.report.engine.layout.emitter.Image;

public class OOXmlUtil {
    private static final int RATIO_POINT_TO_EMUS = 12700;

    public static Image getImageInfo(byte[] data) {
        if (data != null) {
            Image imageInfo = new Image();
            imageInfo.setInput(data);
            imageInfo.check();
            return imageInfo;
        }
        return null;
    }

    public static long convertPointerToEmus(double value) {
        return (long)(value * 12700.0);
    }

    public static String getRelativeUri(String parent, String child) {
        if (!OOXmlUtil.isAbsolute(child)) {
            return child;
        }
        if (!OOXmlUtil.isAbsolute(parent)) {
            throw new IllegalArgumentException("Parent uri must be absolute when child uri is absolute.");
        }
        parent = parent.substring(1);
        if ((child = child.substring(1)).startsWith(parent)) {
            return child.substring(parent.length());
        }
        String[] parentPaths = parent.split("/");
        String[] currentPaths = child.split("/");
        int max = Math.max(parentPaths.length, currentPaths.length);
        int sameCount = 0;
        int i = 0;
        while (i < max) {
            if (!parentPaths[i].equals(currentPaths[i])) break;
            ++sameCount;
            ++i;
        }
        int upLevel = parentPaths.length - sameCount;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < upLevel - 1) {
            buffer.append("../");
            ++i2;
        }
        i2 = sameCount;
        while (i2 < currentPaths.length) {
            buffer.append(currentPaths[i2]);
            if (i2 != currentPaths.length - 1) {
                buffer.append('/');
            }
            ++i2;
        }
        return buffer.toString();
    }

    public static String getAbsoluteUri(String parent, String child) {
        int start;
        if (parent == null || child == null) {
            return null;
        }
        if (OOXmlUtil.isAbsolute(child)) {
            return child;
        }
        String[] parentPaths = parent.split("/");
        String[] childPaths = child.split("/");
        int upLevel = start = parent.endsWith("/") ? 0 : 1;
        String[] stringArray = childPaths;
        int n = childPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String childPath = stringArray[n2];
            String path = childPath.trim();
            if (!"..".equals(path)) break;
            ++upLevel;
            ++n2;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('/');
        int i = 0;
        while (i < parentPaths.length - upLevel) {
            String path = parentPaths[i];
            if (!"".equals(path)) {
                buffer.append(path);
                buffer.append('/');
            }
            ++i;
        }
        i = upLevel - start;
        while (i < childPaths.length) {
            buffer.append(childPaths[i]);
            if (i != childPaths.length - 1) {
                buffer.append('/');
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isAbsolute(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("/");
    }

    public static String getRelationShipId(int id) {
        return "rId" + id;
    }
}

