/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;
import org.eclipse.birt.report.engine.internal.index.v2.DocumentIndexV2Constants;
import org.eclipse.birt.report.engine.internal.index.v2.IndexReader;

public class DocumentIndexReaderV2
implements IDocumentIndexReader,
ReportDocumentConstants,
DocumentIndexV2Constants {
    private IndexReader bookmarks;
    private IndexReader reportlets;
    private IndexReader pageNumbers;
    private IDocArchiveReader archive;

    public DocumentIndexReaderV2(IDocArchiveReader archive) throws IOException {
        this.archive = archive;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public void close() {
        if (this.bookmarks != null) {
            try {
                this.bookmarks.close();
            }
            catch (IOException iOException) {}
            this.bookmarks = null;
        }
        if (this.reportlets != null) {
            try {
                this.reportlets.close();
            }
            catch (IOException iOException) {}
            this.reportlets = null;
        }
        if (this.pageNumbers != null) {
            try {
                this.pageNumbers.close();
            }
            catch (IOException iOException) {}
            this.pageNumbers = null;
        }
    }

    @Override
    public long getOffsetOfBookmark(String bookmark) throws IOException {
        Long value;
        if (this.bookmarks == null) {
            this.bookmarks = this.createIndexReader("/reportletBookmarks");
        }
        if (this.bookmarks != null && (value = this.bookmarks.getLong(bookmark)) != null) {
            return value;
        }
        return -1L;
    }

    @Override
    public long getOffsetOfInstance(String instanceId) throws IOException {
        Long value;
        if (this.reportlets == null) {
            this.reportlets = this.createIndexReader("/reportlet");
        }
        if (this.reportlets != null && (value = this.reportlets.getLong(instanceId)) != null) {
            return value;
        }
        return -1L;
    }

    @Override
    public long getPageOfBookmark(String bookmark) throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexReader("/bookmark");
        }
        if (this.pageNumbers != null) {
            BookmarkContent content = this.pageNumbers.getBookmarkContent(bookmark);
            if (content != null) {
                return content.getPageNumber();
            }
            Long lvalue = this.pageNumbers.getLong(bookmark);
            if (lvalue != null) {
                return lvalue;
            }
        }
        return -1L;
    }

    @Override
    public BookmarkContent getBookmark(String bookmark) throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexReader("/bookmark");
        }
        if (this.pageNumbers != null) {
            return this.pageNumbers.getBookmarkContent(bookmark);
        }
        return null;
    }

    @Override
    public List<String> getBookmarks() throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexReader("/bookmark");
        }
        if (this.pageNumbers != null) {
            final ArrayList<String> allBookmarks = new ArrayList<String>();
            this.pageNumbers.forAllKeys(new IndexReader.KeyListener(){

                @Override
                public void onKey(String key) {
                    if (key != null && !key.startsWith("__TOC_")) {
                        allBookmarks.add(key);
                    }
                }
            });
            return allBookmarks;
        }
        return null;
    }

    @Override
    public List<BookmarkContent> getBookmarkContents() throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexReader("/bookmark");
        }
        if (this.pageNumbers != null) {
            final ArrayList<BookmarkContent> allBookmarks = new ArrayList<BookmarkContent>();
            this.pageNumbers.forAllValues(new IndexReader.ValueListener(){

                @Override
                public void onValue(Object value) {
                    if (value != null) {
                        allBookmarks.add((BookmarkContent)value);
                    }
                }
            });
            return allBookmarks;
        }
        return null;
    }

    private IndexReader createIndexReader(String stream) throws IOException {
        return new IndexReader(this.archive, stream);
    }
}

