/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.providers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractResourceContentProvider
extends AbstractContentProvider {
    private static final String SLASH = "/";
    ResourceSet fResourceSet;

    public AbstractResourceContentProvider(ResourceSet set) {
        this.fResourceSet = set;
    }

    protected void doCollectElements(Object input, List list) throws CoreException {
        if (input == null) {
            return;
        }
        if (input instanceof IContainer) {
            this.findCandidates((IContainer)input, list, this.getKindClass());
            return;
        }
        if (this.isAcceptableKind(input)) {
            list.add(input);
            return;
        }
        Object[] arr = null;
        if (input.getClass().isArray()) {
            arr = (Object[])input;
        } else if (input instanceof List) {
            arr = ((List)input).toArray();
        }
        if (arr == null) {
            return;
        }
        int i = 0;
        while (i < arr.length) {
            this.doCollectElements(arr[i], list);
            ++i;
        }
    }

    public void collectElements(Object input, List list) {
        try {
            this.doCollectElements(input, list);
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
        }
    }

    protected boolean isAcceptableKind(Object obj) {
        Class[] kind = this.getKindClass();
        if (kind == null) {
            return true;
        }
        int i = 0;
        while (i < kind.length) {
            if (kind[i].isInstance(obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List findCandidates(IContainer container, List list, Class[] kind) throws CoreException {
        if (list == null) {
            list = new LinkedList<Object>();
        }
        for (IResource r : this.findCandidates(container)) {
            try {
                Object obj = this.load(r);
                if (!this.isAcceptableKind(obj)) continue;
                list.add(obj);
            }
            catch (Exception ex) {
                BPELUIPlugin.log(ex);
            }
        }
        return list;
    }

    protected Object load(IResource r) {
        String uri = SLASH + r.getProject().getName() + SLASH + r.getProjectRelativePath();
        URI locationURI = URI.createPlatformResourceURI((String)uri);
        Resource resource = this.fResourceSet.getResource(locationURI, true);
        return resource.getContents().get(0);
    }

    protected abstract String[] getKind();

    protected Class[] getKindClass() {
        return null;
    }

    protected int getDepth() {
        return 2;
    }

    protected List findCandidates(IContainer container) throws CoreException {
        LinkedList list = new LinkedList();
        if (container instanceof IWorkspaceRoot) {
            return this.findCandidates(container, list, this.getKind(), this.getDepth() + 1);
        }
        return this.findCandidates(container, list, this.getKind(), this.getDepth());
    }

    protected List findCandidates(IContainer container, List list, String[] kind, int depth) throws CoreException {
        IResource r;
        if (depth <= 0 || !container.isAccessible()) {
            return list;
        }
        --depth;
        boolean bFound = false;
        IResource[] rlist = container.members();
        int i = 0;
        while (i < rlist.length) {
            r = rlist[i];
            if (r.getType() == 1) {
                String name = r.getFileExtension();
                int j = 0;
                while (j < kind.length) {
                    if (name != null && name.equalsIgnoreCase(kind[j])) {
                        bFound = true;
                        list.add(r);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (bFound) {
            depth = 1;
        }
        i = 0;
        while (i < rlist.length) {
            r = rlist[i];
            if (r instanceof IContainer) {
                this.findCandidates((IContainer)r, list, kind, depth);
            }
            ++i;
        }
        return list;
    }
}

