/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ssh.internal.core;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ssh.core.ISshFileHandle;
import org.eclipse.dltk.ssh.internal.core.IOutputStreamCloseListener;
import org.eclipse.dltk.ssh.internal.core.SshConnection;

public class SshFileHandle
implements ISshFileHandle,
IOutputStreamCloseListener {
    private static final int CACHE_LIMIT = 1000;
    private static final Map<SshFileHandle, CacheEntry> attrCache = new HashMap<SshFileHandle, CacheEntry>();
    private SshConnection connection = null;
    private IPath path;
    private SftpATTRS attrs;
    private Map<String, SshFileHandle> children = new HashMap<String, SshFileHandle>();
    private boolean childrenFetched = false;

    public SshFileHandle(SshConnection connection, IPath path, SftpATTRS attrs) {
        this.connection = connection;
        this.path = path;
        this.attrs = attrs;
    }

    @Override
    public ISshFileHandle createFolder(String newEntryName, IProgressMonitor monitor) throws CoreException {
        ISshFileHandle child = this.getChild(newEntryName);
        if (child != null) {
            child.mkdir();
            this.fetchAttrs();
        }
        return child;
    }

    @Override
    public void mkdir() {
        this.connection.mkdir(this.path);
        this.cleanAttrs();
    }

    @Override
    public void delete() throws CoreException {
        this.fetchAttrs();
        if (this.attrs != null) {
            this.connection.delete(this.path, this.attrs.isDir());
            this.cleanAttrs();
        }
    }

    @Override
    public boolean exists() {
        this.fetchAttrs();
        return this.attrs != null;
    }

    private void fetchAttrs() {
        this.fetchAttrs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAttrs() {
        this.attrs = null;
        Map<SshFileHandle, CacheEntry> map = attrCache;
        synchronized (map) {
            attrCache.remove(this);
        }
    }

    private void fetchAttrs(boolean clean) {
        if (this.attrs == null || clean) {
            this.attrs = this.fetchCacheAttrs(clean);
        }
        if (this.attrs != null && this.attrs.isLink()) {
            this.attrs = this.fetchCacheAttrs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SftpATTRS fetchCacheAttrs(boolean clean) {
        long c = 0L;
        Map<SshFileHandle, CacheEntry> map = attrCache;
        synchronized (map) {
            CacheEntry entry;
            if (attrCache.size() > 1000) {
                attrCache.clear();
            } else if (!clean && (entry = attrCache.get(this)) != null && (c = System.currentTimeMillis()) - entry.lastAccess < 10000L) {
                return entry.attrs;
            }
        }
        SftpATTRS attrs = this.connection.getAttrs(this.path);
        if (c == 0L) {
            c = System.currentTimeMillis();
        }
        Map<SshFileHandle, CacheEntry> map2 = attrCache;
        synchronized (map2) {
            attrCache.put(this, new CacheEntry(attrs, c));
        }
        return attrs;
    }

    @Override
    public synchronized ISshFileHandle getChild(String newEntryName) {
        if (this.children.containsKey(newEntryName)) {
            return this.children.get(newEntryName);
        }
        SshFileHandle child = new SshFileHandle(this.connection, this.path.append(newEntryName), null);
        return child;
    }

    @Override
    public synchronized ISshFileHandle[] getChildren(IProgressMonitor monitor) throws CoreException {
        if (!this.childrenFetched) {
            this.fetchChildren();
        }
        return this.children.values().toArray(new SshFileHandle[this.children.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchChildren() {
        Vector<ChannelSftp.LsEntry> list = this.connection.list(this.path);
        if (list != null) {
            this.children.clear();
            long c = System.currentTimeMillis();
            for (ChannelSftp.LsEntry entry : list) {
                String filename = entry.getFilename();
                if (filename.equals(".") || filename.equals("..")) continue;
                SftpATTRS childAttrs = entry.getAttrs();
                IPath childPath = filename.indexOf(58) == -1 ? this.path.append(filename) : this.path.append((IPath)new Path(null, filename));
                SshFileHandle childHandle = new SshFileHandle(this.connection, childPath, childAttrs);
                Map<SshFileHandle, CacheEntry> map = attrCache;
                synchronized (map) {
                    attrCache.put(childHandle, new CacheEntry(childAttrs, c));
                }
                this.children.put(filename, childHandle);
            }
            this.childrenFetched = true;
        }
    }

    @Override
    public InputStream getInputStream(IProgressMonitor monitor) throws CoreException {
        InputStream stream = this.connection.get(this.path);
        return stream;
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }

    @Override
    public OutputStream getOutputStream(IProgressMonitor monitor) throws CoreException {
        OutputStream stream = this.connection.put(this.path, this);
        return stream;
    }

    @Override
    public void streamClosed() {
        this.cleanAttrs();
    }

    @Override
    public boolean isDirectory() {
        this.fetchAttrs();
        if (this.attrs != null) {
            return this.attrs.isDir();
        }
        return false;
    }

    @Override
    public long lastModificationTime() {
        this.fetchAttrs();
        if (this.attrs != null) {
            return (long)this.attrs.getMTime() * 1000L;
        }
        return 0L;
    }

    @Override
    public void setLastModified(long timestamp, IProgressMonitor monitor) throws CoreException {
        this.connection.setLastModified(this.path, timestamp);
        this.cleanAttrs();
    }

    @Override
    public long getSize() {
        this.fetchAttrs();
        if (this.attrs != null) {
            return this.attrs.getSize();
        }
        return 0L;
    }

    @Override
    public boolean isSymlink() {
        SftpATTRS attrs = this.connection.getLAttrs(this.path);
        return attrs != null && attrs.isLink();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SshFileHandle other = (SshFileHandle)obj;
        if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    @Override
    public String readLink() {
        return this.connection.readLink(this.path);
    }

    @Override
    public void move(IPath destination) throws CoreException {
        this.connection.move(this.path, destination);
    }

    private static class CacheEntry {
        final SftpATTRS attrs;
        final long lastAccess;

        public CacheEntry(SftpATTRS attrs, long lastAccess) {
            this.attrs = attrs;
            this.lastAccess = lastAccess;
        }
    }
}

