/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.model.Node;
import org.eclipse.epp.internal.mpc.core.service.AbstractDataStorageService;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IFavoriteList;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IUserFavoritesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMarketplaceService
implements IMarketplaceService {
    private final IMarketplaceService delegate;
    private final Map<String, Reference<Object>> cache = new LinkedHashMap<String, Reference<Object>>();
    private final ReferenceQueue<Object> cacheReferenceQueue = new ReferenceQueue();

    public CachingMarketplaceService(IMarketplaceService delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    public IMarketplaceService getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IMarket> listMarkets(IProgressMonitor monitor) throws CoreException {
        String marketsKey = "Markets:Markets";
        List<? extends IMarket> marketsResult = this.getCached(marketsKey, List.class);
        if (marketsResult == null) {
            marketsResult = this.delegate.listMarkets(monitor);
            Map<String, Reference<Object>> map = this.cache;
            synchronized (map) {
                this.cache(marketsKey, marketsResult);
                for (IMarket iMarket : marketsResult) {
                    this.cacheMarket(iMarket);
                }
            }
        }
        return marketsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMarket getMarket(IMarket market, IProgressMonitor monitor) throws CoreException {
        String marketKey = this.computeMarketKey(market);
        IMarket marketResult = null;
        if (marketKey != null) {
            marketResult = this.getCached(marketKey, IMarket.class);
        }
        if (marketResult == null && (marketResult = this.delegate.getMarket(market, monitor)) != null) {
            Map<String, Reference<Object>> map = this.cache;
            synchronized (map) {
                this.cacheMarket(marketResult);
            }
        }
        return marketResult;
    }

    private void cacheMarket(IMarket market) {
        String marketKey = this.computeMarketKey(market);
        this.cache(marketKey, market);
        List<? extends ICategory> categories = market.getCategory();
        for (ICategory iCategory : categories) {
            this.cacheCategory(iCategory);
        }
    }

    private void cacheCategory(ICategory category) {
        String categoryKey = this.computeCategoryKey(category);
        this.cache(categoryKey, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICategory getCategory(ICategory category, IProgressMonitor monitor) throws CoreException {
        String categoryKey = this.computeCategoryKey(category);
        ICategory categoryResult = null;
        if (categoryKey != null) {
            categoryResult = this.getCached(categoryKey, ICategory.class);
        }
        if (categoryResult == null && (categoryResult = this.delegate.getCategory(category, monitor)) != null) {
            Map<String, Reference<Object>> map = this.cache;
            synchronized (map) {
                this.cacheCategory(categoryResult);
            }
        }
        return categoryResult;
    }

    @Override
    public INode getNode(INode node, IProgressMonitor monitor) throws CoreException {
        String nodeUrlKey;
        String nodeKey = this.computeNodeKey(node);
        INode nodeResult = null;
        if (nodeKey != null) {
            nodeResult = this.getCached(nodeKey, INode.class);
        }
        if (nodeResult == null && (nodeUrlKey = this.computeNodeUrlKey(node)) != null) {
            nodeResult = this.getCached(nodeUrlKey, INode.class);
        }
        if (nodeResult == null && (nodeResult = this.delegate.getNode(node, monitor)) != null) {
            this.cacheNode(nodeResult);
        }
        return nodeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheNode(INode node) {
        Map<String, Reference<Object>> map = this.cache;
        synchronized (map) {
            this.cache(this.computeNodeKey(node), node);
            this.cache(this.computeNodeUrlKey(node), node);
            this.cache(this.computeNodeIdUrlKey(node), node);
        }
    }

    @Override
    public List<INode> getNodes(Collection<? extends INode> nodes, IProgressMonitor monitor) throws CoreException {
        LinkedHashMap<INode, INode> resolvedNodes = new LinkedHashMap<INode, INode>();
        ArrayList<INode> unresolvedNodes = new ArrayList<INode>();
        for (INode iNode : nodes) {
            if (this.mapCachedNode(iNode, resolvedNodes)) continue;
            unresolvedNodes.add(iNode);
        }
        if (!unresolvedNodes.isEmpty()) {
            List<INode> list = this.delegate.getNodes(unresolvedNodes, monitor);
            for (INode iNode : list) {
                this.cacheNode(iNode);
            }
            for (INode iNode : unresolvedNodes) {
                this.mapCachedNode(iNode, resolvedNodes);
            }
        }
        ArrayList<INode> arrayList = new ArrayList<INode>(nodes.size());
        for (INode iNode : nodes) {
            INode resolvedNode = (INode)resolvedNodes.get(iNode);
            if (resolvedNode == null) continue;
            arrayList.add(resolvedNode);
        }
        return arrayList;
    }

    private boolean mapCachedNode(INode node, Map<INode, INode> resolvedNodes) {
        INode nodeResult;
        String nodeKey = this.computeNodeKey(node);
        if (nodeKey != null && (nodeResult = this.getCached(nodeKey, INode.class)) != null) {
            resolvedNodes.put(node, nodeResult);
            return true;
        }
        return false;
    }

    private void cache(String key, Object value) {
        if (key != null) {
            this.cache.put(key, new SoftReference<Object>(value, this.cacheReferenceQueue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getCached(String key, Class<T> type) {
        Map<String, Reference<Object>> map = this.cache;
        synchronized (map) {
            this.gcCache();
            Reference<Object> reference = this.cache.get(key);
            if (reference != null) {
                return type.cast(reference.get());
            }
        }
        return null;
    }

    private void gcCache() {
        if (this.cacheReferenceQueue.poll() != null) {
            while (this.cacheReferenceQueue.poll() != null) {
            }
            Iterator<Reference<Object>> i = this.cache.values().iterator();
            while (i.hasNext()) {
                Reference<Object> reference = i.next();
                if (!reference.isEnqueued()) continue;
                i.remove();
            }
        }
    }

    private String computeNodeKey(INode node) {
        if (node.getId() != null) {
            return "Node:" + node.getId();
        }
        return null;
    }

    private String computeNodeUrlKey(INode node) {
        if (node.getUrl() != null) {
            return "Node:" + node.getUrl();
        }
        return null;
    }

    private String computeNodeIdUrlKey(INode node) {
        if (node.getId() != null) {
            String url = URLUtil.appendPath(this.getBaseUrl().toString(), "node", node.getId());
            return "Node:" + url;
        }
        return null;
    }

    private String computeMarketKey(IMarket market) {
        if (market.getId() != null) {
            return "Market:" + market.getId();
        }
        return null;
    }

    private String computeCategoryKey(ICategory category) {
        if (category.getId() != null) {
            return "Category:" + category.getId();
        }
        return null;
    }

    @Override
    public ISearchResult search(final IMarket market, final ICategory category, final String queryText, IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("search", market, category, queryText);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.search(market, category, queryText, monitor);
            }
        });
    }

    @Override
    public ISearchResult tagged(final String tag, IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("tagged", null, null, tag);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.tagged(tag, monitor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISearchResult performSearch(IProgressMonitor monitor, String key, SearchOperation searchOperation) throws CoreException {
        ISearchResult result = null;
        Map<String, Reference<Object>> map = this.cache;
        synchronized (map) {
            Reference<Object> reference = this.cache.get(key);
            if (reference != null) {
                result = (ISearchResult)reference.get();
            }
        }
        if (result == null && (result = searchOperation.doSearch(monitor)) != null) {
            map = this.cache;
            synchronized (map) {
                this.cache(key, result);
                for (INode iNode : result.getNodes()) {
                    this.cache(this.computeNodeKey(iNode), iNode);
                }
            }
        }
        return result;
    }

    private String computeSearchKey(String prefix, IMarket market, ICategory category, String queryText) {
        return String.valueOf(prefix) + ":" + (market == null ? "" : market.getId()) + ":" + (category == null ? "" : category.getId()) + ":" + (queryText == null ? "" : queryText.trim());
    }

    @Override
    public URL getBaseUrl() {
        return this.delegate.getBaseUrl();
    }

    @Override
    public ISearchResult featured(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("featured", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.featured(monitor);
            }
        });
    }

    @Override
    public ISearchResult featured(final IMarket market, final ICategory category, IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("featured", market, category, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.featured(market, category, monitor);
            }
        });
    }

    @Override
    public ISearchResult recent(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("recent", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.recent(monitor);
            }
        });
    }

    @Override
    public ISearchResult topFavorites(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("favorites", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.topFavorites(monitor);
            }
        });
    }

    @Override
    public ISearchResult popular(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("popular", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.popular(monitor);
            }
        });
    }

    @Override
    public ISearchResult related(final List<? extends INode> basedOn, IProgressMonitor monitor) throws CoreException {
        String searchKey = null;
        if (basedOn != null && !basedOn.isEmpty()) {
            StringBuilder searchKeyBldr = new StringBuilder();
            for (INode iNode : basedOn) {
                searchKeyBldr.append(iNode.getId()).append('+');
            }
            searchKey = searchKeyBldr.substring(0, searchKeyBldr.length() - 1);
        }
        String key = this.computeSearchKey("related", null, null, searchKey);
        return this.performSearch(monitor, key, new SearchOperation(){

            public ISearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.related(basedOn, monitor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INews news(IProgressMonitor monitor) throws CoreException {
        String newsKey = "News:News";
        INews newsResult = this.getCached(newsKey, INews.class);
        if (newsResult == null) {
            newsResult = this.delegate.news(monitor);
            Map<String, Reference<Object>> map = this.cache;
            synchronized (map) {
                this.cache(newsKey, newsResult);
            }
        }
        return newsResult;
    }

    public void reportInstallError(IProgressMonitor monitor, IStatus result, Set<Node> nodes, Set<String> iuIdsAndVersions, String resolutionDetails) throws CoreException {
        this.reportInstallError(result, nodes, iuIdsAndVersions, resolutionDetails, monitor);
    }

    @Override
    public void reportInstallError(IStatus result, Set<? extends INode> nodes, Set<String> iuIdsAndVersions, String resolutionDetails, IProgressMonitor monitor) throws CoreException {
        this.delegate.reportInstallError(result, nodes, iuIdsAndVersions, resolutionDetails, monitor);
    }

    @Override
    public void reportInstallSuccess(INode node, IProgressMonitor monitor) {
        this.delegate.reportInstallSuccess(node, monitor);
    }

    @Override
    @Deprecated
    public ISearchResult favorites(IProgressMonitor monitor) throws CoreException {
        return this.topFavorites(monitor);
    }

    @Override
    public List<IFavoriteList> userFavoriteLists(IProgressMonitor monitor) throws CoreException {
        return this.delegate.userFavoriteLists(monitor);
    }

    @Override
    public ISearchResult userFavorites(IProgressMonitor monitor) throws CoreException, AbstractDataStorageService.NotAuthorizedException {
        return this.delegate.userFavorites(monitor);
    }

    @Override
    public void userFavorites(List<? extends INode> nodes, IProgressMonitor monitor) throws CoreException, AbstractDataStorageService.NotAuthorizedException {
        this.delegate.userFavorites(nodes, monitor);
    }

    @Override
    public IUserFavoritesService getUserFavoritesService() {
        return this.delegate.getUserFavoritesService();
    }

    @Override
    public ISearchResult userFavorites(URI favoritesUri, IProgressMonitor monitor) throws CoreException {
        return this.delegate.userFavorites(favoritesUri, monitor);
    }

    private static interface SearchOperation {
        public ISearchResult doSearch(IProgressMonitor var1) throws CoreException;
    }
}

