/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.adapt.inject;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef.common.adapt.IAdaptable;

class AdaptableScope<A extends IAdaptable>
implements Scope {
    private static Map<IAdaptable, Map<Key<?>, Object>> scopedInstances = new IdentityHashMap();
    private A adaptable = null;
    private Class<? extends A> type;

    public AdaptableScope(Class<? extends A> type) {
        this.type = type;
    }

    public void enter(A instance) {
        if (!scopedInstances.containsKey(instance)) {
            scopedInstances.put((IAdaptable)instance, new HashMap());
        }
        this.adaptable = instance;
    }

    public void leave(A instance) {
        this.adaptable = null;
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                if (AdaptableScope.this.adaptable == null) {
                    throw new IllegalStateException(key + " is scoped to adaptable '" + AdaptableScope.this.type + "', for which no scope has been activated. You can only scope adapters in a scope of a transitive adaptable.");
                }
                Map scope = (Map)scopedInstances.get(AdaptableScope.this.adaptable);
                Object instance = scope.get(key);
                if (instance == null && (instance = unscoped.get()) != null) {
                    scope.put(key, instance);
                }
                return instance;
            }
        };
    }
}

