/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Node;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.mvc.fx.behaviors.IBehavior;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractBehavior
implements IBehavior {
    private ReadOnlyObjectWrapper<IVisualPart<? extends Node>> hostProperty = new ReadOnlyObjectWrapper();
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private Map<Set<IVisualPart<? extends Node>>, List<IFeedbackPart<? extends Node>>> feedbackPerTargetSet = new HashMap<Set<IVisualPart<? extends Node>>, List<IFeedbackPart<? extends Node>>>();
    private Map<Set<IVisualPart<? extends Node>>, List<IHandlePart<? extends Node>>> handlesPerTargetSet = new HashMap<Set<IVisualPart<? extends Node>>, List<IHandlePart<? extends Node>>>();

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IVisualPart<? extends Node>> adaptableProperty() {
        return this.hostProperty.getReadOnlyProperty();
    }

    protected void addAnchoreds(Collection<? extends IVisualPart<? extends Node>> targets, List<? extends IVisualPart<? extends Node>> anchoreds) {
        if (anchoreds != null && !anchoreds.isEmpty()) {
            targets.iterator().next().getRoot().addChildren(anchoreds);
            for (IVisualPart<? extends Node> iVisualPart : anchoreds) {
                for (IVisualPart<? extends Node> iVisualPart2 : targets) {
                    iVisualPart.attachToAnchorage(iVisualPart2);
                }
            }
        }
    }

    protected void addAnchoreds(Collection<? extends IVisualPart<? extends Node>> targets, List<? extends IVisualPart<? extends Node>> anchoreds, int insertionIndex) {
        if (anchoreds != null && !anchoreds.isEmpty()) {
            targets.iterator().next().getRoot().addChildren(anchoreds, insertionIndex);
            for (IVisualPart<? extends Node> iVisualPart : anchoreds) {
                for (IVisualPart<? extends Node> iVisualPart2 : targets) {
                    iVisualPart.attachToAnchorage(iVisualPart2);
                }
            }
        }
    }

    protected void addFeedback(IVisualPart<? extends Node> target) {
        this.addFeedback(Collections.singletonList(target));
    }

    protected void addFeedback(List<? extends IVisualPart<? extends Node>> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("The given target parts may not be null.");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("The given collection of target parts may not be empty.");
        }
        Set<IVisualPart<? extends Node>> targetSet = this.createTargetSet(targets);
        if (this.hasFeedback(targetSet)) {
            throw new IllegalStateException("Feedback was already added for the given set of target parts.");
        }
        IFeedbackPartFactory factory = this.getFeedbackPartFactory(targets.get(0).getRoot().getViewer());
        List<Object> feedbackParts = null;
        if (factory != null) {
            feedbackParts = factory.createFeedbackParts(targets, Collections.emptyMap());
        }
        if (feedbackParts == null) {
            feedbackParts = Collections.emptyList();
        }
        this.getFeedbackPerTargetSet().put(targetSet, feedbackParts);
        if (!feedbackParts.isEmpty()) {
            this.addAnchoreds(targets, feedbackParts);
        }
    }

    protected void addHandles(IVisualPart<? extends Node> target) {
        this.addHandles(Collections.singletonList(target));
    }

    protected void addHandles(List<? extends IVisualPart<? extends Node>> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("The given target parts may not be null.");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("The given collection of target parts may not be empty.");
        }
        Set<IVisualPart<? extends Node>> targetSet = this.createTargetSet(targets);
        if (this.hasHandles(targetSet)) {
            throw new IllegalStateException("Handles were already added for the given set of target parts.");
        }
        IHandlePartFactory factory = this.getHandlePartFactory(targets.get(0).getRoot().getViewer());
        List<Object> handleParts = null;
        if (factory != null) {
            handleParts = factory.createHandleParts(targets, Collections.emptyMap());
        }
        if (handleParts == null) {
            handleParts = Collections.emptyList();
        }
        this.getHandlesPerTargetSet().put(targetSet, handleParts);
        if (!handleParts.isEmpty()) {
            this.addAnchoreds(targets, handleParts);
        }
    }

    protected void clearFeedback() {
        Set<Set<IVisualPart<? extends Node>>> keys = this.getFeedbackPerTargetSet().keySet();
        for (Set<IVisualPart<? extends Node>> key : new ArrayList<Set<IVisualPart<? extends Node>>>(keys)) {
            this.removeFeedback(key);
        }
    }

    protected void clearHandles() {
        Set<Set<IVisualPart<? extends Node>>> keys = this.getHandlesPerTargetSet().keySet();
        for (Set<IVisualPart<? extends Node>> key : new ArrayList<Set<IVisualPart<? extends Node>>>(keys)) {
            this.removeHandles(key);
        }
    }

    private Set<IVisualPart<? extends Node>> createTargetSet(Collection<? extends IVisualPart<? extends Node>> targets) {
        Set<IVisualPart<? extends Node>> targetSet = Collections.newSetFromMap(new IdentityHashMap());
        targetSet.addAll(targets);
        return targetSet;
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void doActivate() {
    }

    protected void doDeactivate() {
    }

    public IVisualPart<? extends Node> getAdaptable() {
        return this.getHost();
    }

    protected List<IFeedbackPart<? extends Node>> getFeedback(Collection<? extends IVisualPart<? extends Node>> targets) {
        List<IFeedbackPart<? extends Node>> list = this.getFeedbackPerTargetSet().get(targets instanceof Set ? (Set<IVisualPart<? extends Node>>)targets : this.createTargetSet(targets));
        return list == null ? Collections.emptyList() : list;
    }

    protected List<IFeedbackPart<? extends Node>> getFeedback(IVisualPart<? extends Node> target) {
        return this.getFeedback(Collections.singletonList(target));
    }

    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        throw new UnsupportedOperationException("Need to implement getFeedbackPartFactory() for " + this.getClass());
    }

    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer, String role) {
        return (IFeedbackPartFactory)viewer.getAdapter(AdapterKey.get(IFeedbackPartFactory.class, (String)role));
    }

    protected Map<Set<IVisualPart<? extends Node>>, List<IFeedbackPart<? extends Node>>> getFeedbackPerTargetSet() {
        return this.feedbackPerTargetSet;
    }

    protected IHandlePartFactory getHandlePartFactory(IViewer viewer) {
        throw new UnsupportedOperationException("Need to implement getHandlePartFactory() for " + this.getClass());
    }

    protected IHandlePartFactory getHandlePartFactory(IViewer viewer, String role) {
        return (IHandlePartFactory)viewer.getAdapter(AdapterKey.get(IHandlePartFactory.class, (String)role));
    }

    protected List<IHandlePart<? extends Node>> getHandles(Collection<? extends IVisualPart<? extends Node>> targets) {
        List<IHandlePart<? extends Node>> list = this.getHandlesPerTargetSet().get(targets instanceof Set ? (Set<IVisualPart<? extends Node>>)targets : this.createTargetSet(targets));
        return list == null ? Collections.emptyList() : list;
    }

    protected List<IHandlePart<? extends Node>> getHandles(IVisualPart<? extends Node> target) {
        return this.getHandles(Collections.singletonList(target));
    }

    protected Map<Set<IVisualPart<? extends Node>>, List<IHandlePart<? extends Node>>> getHandlesPerTargetSet() {
        return this.handlesPerTargetSet;
    }

    @Override
    public IVisualPart<? extends Node> getHost() {
        return (IVisualPart)this.hostProperty.get();
    }

    protected boolean hasFeedback(Collection<? extends IVisualPart<? extends Node>> targets) {
        return this.getFeedbackPerTargetSet().containsKey(targets instanceof Set ? (Set<IVisualPart<? extends Node>>)targets : this.createTargetSet(targets));
    }

    protected boolean hasFeedback(IVisualPart<? extends Node> target) {
        return this.hasFeedback(Collections.singletonList(target));
    }

    protected boolean hasHandles(Collection<? extends IVisualPart<? extends Node>> targets) {
        return this.getHandlesPerTargetSet().containsKey(targets instanceof Set ? (Set<IVisualPart<? extends Node>>)targets : this.createTargetSet(targets));
    }

    protected boolean hasHandles(IVisualPart<? extends Node> target) {
        return this.hasHandles(Collections.singletonList(target));
    }

    public final boolean isActive() {
        return this.acs.isActive();
    }

    protected void removeAnchoreds(Collection<? extends IVisualPart<? extends Node>> targets, List<? extends IVisualPart<? extends Node>> anchoreds) {
        if (anchoreds != null && !anchoreds.isEmpty()) {
            for (IVisualPart<? extends Node> iVisualPart : anchoreds) {
                for (IVisualPart<? extends Node> iVisualPart2 : targets) {
                    iVisualPart.detachFromAnchorage(iVisualPart2);
                }
            }
            anchoreds.iterator().next().getRoot().removeChildren(anchoreds);
        }
    }

    protected void removeFeedback(Collection<? extends IVisualPart<? extends Node>> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("The given list of target parts may not be null.");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("The given list of target parts may not be empty.");
        }
        this.removeFeedback(targets instanceof Set ? (Set<IVisualPart<? extends Node>>)targets : this.createTargetSet(targets));
    }

    protected void removeFeedback(IVisualPart<? extends Node> target) {
        if (target == null) {
            throw new IllegalArgumentException("The given target part may not be null.");
        }
        this.removeFeedback(Collections.singletonList(target));
    }

    protected void removeFeedback(Set<? extends IVisualPart<? extends Node>> targetSet) {
        if (targetSet == null) {
            throw new IllegalArgumentException("The given set of target parts may not be null.");
        }
        if (targetSet.isEmpty()) {
            throw new IllegalArgumentException("The given set of target parts may not be empty.");
        }
        if (!this.hasFeedback(targetSet)) {
            throw new IllegalStateException("Feedback was not added for the given set of target parts.");
        }
        List<IFeedbackPart<? extends Node>> feedbackParts = this.getFeedbackPerTargetSet().remove(targetSet);
        if (!feedbackParts.isEmpty()) {
            this.removeAnchoreds(targetSet, feedbackParts);
        }
        for (IFeedbackPart<? extends Node> fp : feedbackParts) {
            fp.dispose();
        }
    }

    protected void removeHandles(Collection<? extends IVisualPart<? extends Node>> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("The given list of target parts may not be null.");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("The given list of target parts may not be empty.");
        }
        this.removeHandles(targets instanceof Set ? (Set<IVisualPart<? extends Node>>)targets : this.createTargetSet(targets));
    }

    protected void removeHandles(IVisualPart<? extends Node> target) {
        this.removeHandles(Collections.singletonList(target));
    }

    protected void removeHandles(Set<? extends IVisualPart<? extends Node>> targetSet) {
        if (targetSet == null) {
            throw new IllegalArgumentException("The given set of target parts may not be null.");
        }
        if (targetSet.isEmpty()) {
            throw new IllegalArgumentException("The given set of target parts may not be empty.");
        }
        if (!this.hasHandles(targetSet)) {
            throw new IllegalStateException("Handles were not added for the given set of target parts.");
        }
        List<IHandlePart<? extends Node>> handleParts = this.getHandlesPerTargetSet().remove(targetSet);
        if (!handleParts.isEmpty()) {
            this.removeAnchoreds(targetSet, handleParts);
        }
        for (IHandlePart<? extends Node> hp : handleParts) {
            hp.dispose();
        }
    }

    public void setAdaptable(IVisualPart<? extends Node> adaptable) {
        this.hostProperty.set(adaptable);
    }

    public IHandlePart<? extends Node> updateHandles(IVisualPart<? extends Node> target, Comparator<IHandlePart<? extends Node>> interactedWithComparator, IHandlePart<? extends Node> interactedWith) {
        return this.updateHandles(Collections.singletonList(target), interactedWithComparator, interactedWith);
    }

    public IHandlePart<? extends Node> updateHandles(List<? extends IVisualPart<? extends Node>> targets, Comparator<IHandlePart<? extends Node>> interactedWithComparator, IHandlePart<? extends Node> interactedWith) {
        if (targets == null) {
            throw new IllegalArgumentException("The given target parts may not be null.");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("The given collection of target parts may not be empty.");
        }
        Set<IVisualPart<? extends Node>> targetSet = this.createTargetSet(targets);
        if (!this.hasHandles(targetSet)) {
            return null;
        }
        IRootPart<Node> root = targets.get(0).getRoot();
        IViewer viewer = root.getViewer();
        IHandlePartFactory handlePartFactory = this.getHandlePartFactory(viewer);
        List<IHandlePart<? extends Node>> newHandles = handlePartFactory.createHandleParts(targets, Collections.emptyMap());
        IHandlePart replacementHandle = null;
        if (newHandles != null && !newHandles.isEmpty()) {
            Comparable comparable;
            int compareTo;
            ArrayList<Object> oldHandles;
            List<IHandlePart<? extends Node>> currentHandleParts;
            ArrayList<IHandlePart<? extends Node>> toBeAdded = new ArrayList<IHandlePart<? extends Node>>(newHandles);
            this.addAnchoreds(targets, toBeAdded);
            if (interactedWithComparator != null) {
                double minDistance = -1.0;
                for (IHandlePart iHandlePart : toBeAdded) {
                    double distance = interactedWithComparator.compare(interactedWith, iHandlePart);
                    if (replacementHandle != null && !(distance < minDistance)) continue;
                    minDistance = distance;
                    replacementHandle = iHandlePart;
                }
                if (replacementHandle != null) {
                    toBeAdded.remove(replacementHandle);
                }
            }
            if ((currentHandleParts = this.getHandlesPerTargetSet().get(targetSet)) != null && !currentHandleParts.isEmpty()) {
                oldHandles = new ArrayList<IHandlePart<? extends Node>>(currentHandleParts);
                if (interactedWith != null) {
                    oldHandles.remove(interactedWith);
                }
                ArrayList<IHandlePart> toBeRemoved = new ArrayList<IHandlePart>();
                Iterator iterator = oldHandles.iterator();
                while (iterator.hasNext()) {
                    IHandlePart oldHandle = (IHandlePart)iterator.next();
                    boolean noLongerExists = true;
                    for (IHandlePart iHandlePart : toBeAdded) {
                        if (!(iHandlePart instanceof Comparable) || iHandlePart.getClass() != oldHandle.getClass() || (compareTo = (comparable = (Comparable)((Object)oldHandle)).compareTo(iHandlePart)) != 0) continue;
                        noLongerExists = false;
                        break;
                    }
                    if (!noLongerExists) continue;
                    toBeRemoved.add(oldHandle);
                    iterator.remove();
                }
                this.removeAnchoreds(targets, toBeRemoved);
                this.getHandlesPerTargetSet().get(targetSet).removeAll(toBeRemoved);
                for (IHandlePart hp : toBeRemoved) {
                    hp.dispose();
                }
            } else {
                oldHandles = new ArrayList();
            }
            ArrayList<IHandlePart> toBeDisposed = new ArrayList<IHandlePart>();
            Iterator iterator = toBeAdded.iterator();
            while (iterator.hasNext()) {
                IHandlePart newHandle = (IHandlePart)iterator.next();
                boolean existsAlready = false;
                for (IHandlePart iHandlePart : oldHandles) {
                    if (!(iHandlePart instanceof Comparable) || newHandle.getClass() != iHandlePart.getClass() || (compareTo = (comparable = (Comparable)((Object)iHandlePart)).compareTo(newHandle)) != 0) continue;
                    existsAlready = true;
                    iHandlePart.refreshVisual();
                    break;
                }
                if (!existsAlready) continue;
                toBeDisposed.add(newHandle);
                iterator.remove();
            }
            if (replacementHandle != null) {
                toBeDisposed.add(replacementHandle);
            }
            this.removeAnchoreds(targets, toBeDisposed);
            for (IHandlePart hp : toBeDisposed) {
                hp.dispose();
            }
            if (!this.getHandlesPerTargetSet().containsKey(targetSet)) {
                this.getHandlesPerTargetSet().put(targetSet, new ArrayList());
            } else {
                this.getHandlesPerTargetSet().put(targetSet, new ArrayList(this.getHandlesPerTargetSet().get(targetSet)));
            }
            this.getHandlesPerTargetSet().get(targetSet).addAll(toBeAdded);
        }
        return replacementHandle;
    }
}

