/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.clipboard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.ui.internal.util.clipboard.UriTransferData;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class UriTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "URI-transfer-format";
    private static final int TYPE_ID = UriTransfer.registerType((String)"URI-transfer-format");
    private static final String URI_SEP = "#?#";
    private static final String CHARSET = "UTF-8";
    private static final UriTransfer INSTANCE = new UriTransfer();

    public static UriTransfer getInstance() {
        return INSTANCE;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        block13: {
            if (data == null) {
                return;
            }
            UriTransferData realData = (UriTransferData)data;
            if (realData.getUriStrings().isEmpty()) {
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            try {
                try {
                    byte[] bytes = this.toTransferBytes(realData.getUriStrings());
                    dataOut.writeInt(bytes.length);
                    dataOut.write(bytes);
                    super.javaToNative((Object)out.toByteArray(), transferData);
                }
                catch (IOException e) {
                    T.racer().error("Error when writing transfer data", (Throwable)e);
                    try {
                        dataOut.close();
                        out.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    dataOut.close();
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                dataOut.close();
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Loose catch block
     */
    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes;
        FilterInputStream dataIn;
        ByteArrayInputStream in;
        block17: {
            in = null;
            dataIn = null;
            bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null && bytes.length != 0) break block17;
            try {
                if (in != null) {
                    in.close();
                    dataIn.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
        in = new ByteArrayInputStream(bytes);
        dataIn = new DataInputStream(in);
        int len = ((DataInputStream)dataIn).readInt();
        byte[] uriBytes = new byte[len];
        ((DataInputStream)dataIn).readFully(uriBytes);
        List<String> uriStrings = this.fromTransferBytes(uriBytes);
        UriTransferData uriTransferData = new UriTransferData(uriStrings);
        try {
            if (in != null) {
                in.close();
                dataIn.close();
            }
        }
        catch (IOException iOException) {}
        return uriTransferData;
        catch (IOException e) {
            try {
                T.racer().error("Error when writing transfer data", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                        dataIn.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                    dataIn.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private byte[] toTransferBytes(List<String> uriStrings) throws IOException {
        StringBuilder b = new StringBuilder();
        Iterator<String> iter = uriStrings.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            b.append(s);
            if (!iter.hasNext()) continue;
            b.append(URI_SEP);
        }
        return b.toString().getBytes(CHARSET);
    }

    private List<String> fromTransferBytes(byte[] bytes) throws IOException {
        String all = new String(bytes, CHARSET);
        String[] parts = all.split(Pattern.quote(URI_SEP));
        return Arrays.asList(parts);
    }

    public String toString() {
        return TYPE_NAME;
    }

    private UriTransfer() {
    }
}

