/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_Clean")
class Clean
extends TextBuiltin {
    @Option(name="-d", usage="usage_removeUntrackedDirectories")
    private boolean dirs = false;
    @Option(name="--force", aliases={"-f"}, usage="usage_forceClean")
    private boolean force = false;
    @Option(name="--dryRun", aliases={"-n"})
    private boolean dryRun = false;

    Clean() {
    }

    @Override
    protected void run() throws Exception {
        try (Git git = new Git(this.db);){
            boolean requireForce = git.getRepository().getConfig().getBoolean("clean", "requireForce", true);
            if (requireForce && !this.force && !this.dryRun) {
                throw Clean.die(CLIText.fatalError(CLIText.get().cleanRequireForce));
            }
            Set removedFiles = git.clean().setCleanDirectories(this.dirs).setDryRun(this.dryRun).call();
            for (String removedFile : removedFiles) {
                this.outw.println(MessageFormat.format(CLIText.get().removing, removedFile));
            }
        }
    }
}

