/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.documentation;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension2;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.ldt.core.internal.Activator;
import org.eclipse.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.ldt.core.internal.ast.models.LuaDLTKModelUtils;
import org.eclipse.ldt.core.internal.ast.models.common.IDocumentationHolder;
import org.eclipse.ldt.core.internal.ast.models.common.LuaSourceRoot;

public class LuaDocumentationProvider
implements IScriptDocumentationProvider,
IScriptDocumentationProviderExtension,
IScriptDocumentationProviderExtension2 {
    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        try {
            String memberDocumentation = this.getMemberDocumentation(element);
            if (memberDocumentation != null && !memberDocumentation.isEmpty()) {
                return new StringReader(memberDocumentation);
            }
        }
        catch (ModelException e) {
            Activator.logWarning((String)("unable to get documentation for :" + element), (Throwable)e);
        }
        return null;
    }

    public Reader getInfo(String content) {
        return null;
    }

    public IDocumentationResponse describeKeyword(String keyword, IModelElement context) {
        return null;
    }

    public IDocumentationResponse getDocumentationFor(Object element) {
        try {
            String documentation = null;
            if (element instanceof IMember) {
                documentation = this.getMemberDocumentation((IMember)element);
            } else if (element instanceof ISourceModule) {
                documentation = this.getModuleDocumentation((ISourceModule)element);
            }
            if (documentation != null && !documentation.isEmpty()) {
                return new TextDocumentationResponse(element, null, documentation);
            }
        }
        catch (ModelException e) {
            Activator.logWarning((String)("unable to get documentation for :" + element), (Throwable)e);
        }
        return null;
    }

    private String getMemberDocumentation(IMember member) throws ModelException {
        if (LuaDLTKModelUtils.isModule((IMember)member)) {
            return this.getModuleDocumentation(member.getSourceModule());
        }
        ASTNode astNode = LuaASTModelUtils.getASTNode((IModelElement)member);
        if (astNode instanceof IDocumentationHolder) {
            return ((IDocumentationHolder)astNode).getDocumentation();
        }
        return null;
    }

    private String getModuleDocumentation(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (moduleDeclaration instanceof LuaSourceRoot) {
            LuaSourceRoot root = (LuaSourceRoot)moduleDeclaration;
            return root.getFileapi().getDocumentation();
        }
        return null;
    }
}

