/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.internal.vagrant.core.Activator;
import org.eclipse.linuxtools.internal.vagrant.core.EnvironmentsManager;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantConnection;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.vagrant.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.CreateVMWizard;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.WizardMessages;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.VagrantException;
import org.eclipse.linuxtools.vagrant.core.VagrantService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateVmCommandHandler
extends AbstractHandler {
    private static final String CREATE_VM_MSG = "CreateVM.msg";
    private static final String CRATE_VM_TITLE = "CreateVM.title";

    public Object execute(ExecutionEvent event) {
        if (VagrantConnection.findVagrantPath() == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)WizardMessages.getString("VagrantCommandNotFound.title"), (String)WizardMessages.getString("VagrantCommandNotFound.msg")));
        } else {
            IVagrantBox selectedBox;
            CreateVMWizard wizard;
            boolean finished;
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            List<IVagrantBox> selectedBoxes = CommandUtils.getSelectedImages(activePart);
            if (selectedBoxes.size() <= 1 && (finished = CommandUtils.openWizard((IWizard)(wizard = new CreateVMWizard(selectedBox = selectedBoxes.isEmpty() ? null : selectedBoxes.get(0))), HandlerUtil.getActiveShell((ExecutionEvent)event)))) {
                this.performCreateVM(wizard.getVMName(), wizard.getBoxReference(), wizard.getVMFile(), wizard.getVMEnvironment());
            }
        }
        return null;
    }

    private void performCreateVM(final String vmName, final String boxRef, final String vmFile, final Map<String, String> environment) {
        Job createVMJob = new Job(DVMessages.getFormattedString(CREATE_VM_MSG, new String[0])){

            protected IStatus run(IProgressMonitor monitor) {
                File vagrantDir;
                monitor.beginTask(DVMessages.getFormattedString(CreateVmCommandHandler.CRATE_VM_TITLE, vmName), -1);
                IVagrantConnection connection = VagrantService.getInstance();
                if (CreateVmCommandHandler.this.findVM(connection, vmName) != null) {
                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)WizardMessages.getString("CreateVmCommandHandler.VMExists.title"), (String)WizardMessages.getString("CreateVmCommandHandler.VMExists.msg")));
                    return Status.CANCEL_STATUS;
                }
                IVagrantBox box = null;
                String boxName = boxRef;
                if (vmFile == null) {
                    boolean isValidURL = true;
                    try {
                        new URL(boxRef);
                    }
                    catch (MalformedURLException e1) {
                        isValidURL = false;
                    }
                    if (Paths.get(boxRef, new String[0]).toFile().canRead() || isValidURL) {
                        try {
                            String boxPath = boxRef;
                            boxName = boxRef.substring(boxRef.lastIndexOf(File.separator) + 1).replace(".box", "");
                            connection.addBox(boxName, boxPath, isValidURL);
                        }
                        catch (VagrantException vagrantException) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    vagrantDir = CreateVmCommandHandler.this.performInit(vmName, boxName, connection);
                    box = CreateVmCommandHandler.this.findBox(connection, boxName);
                    while (box == null && isValidURL) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        connection.getVMs(true);
                        box = CreateVmCommandHandler.this.findBox(connection, boxName);
                        if (!monitor.isCanceled()) continue;
                        CommandUtils.delete(vagrantDir);
                        return Status.CANCEL_STATUS;
                    }
                } else {
                    vagrantDir = Paths.get(vmFile, new String[0]).getParent().toFile();
                }
                EnvironmentsManager.getSingleton().setEnvironment(vagrantDir, environment);
                String provider = box == null ? null : box.getProvider();
                connection.up(vagrantDir, provider);
                connection.getVMs(true);
                return Status.OK_STATUS;
            }
        };
        createVMJob.setUser(true);
        createVMJob.schedule();
    }

    private IVagrantBox findBox(IVagrantConnection connection, String boxName) {
        IVagrantBox box = null;
        for (IVagrantBox b : connection.getBoxes()) {
            if (!b.getName().equals(boxName)) continue;
            box = b;
            break;
        }
        return box;
    }

    private IVagrantVM findVM(IVagrantConnection connection, String vmName) {
        IVagrantVM vm = null;
        for (IVagrantVM v : connection.getVMs()) {
            if (!v.name().equals(vmName)) continue;
            vm = v;
            break;
        }
        return vm;
    }

    private File performInit(String vmName, String boxName, IVagrantConnection connection) {
        String stateLoc = Activator.getDefault().getStateLocation().toOSString();
        File vagrantDir = Paths.get(stateLoc, vmName).toFile();
        if (!vagrantDir.mkdir()) {
            CommandUtils.delete(vagrantDir);
            vagrantDir.mkdir();
        }
        connection.init(vagrantDir);
        Path vagrantFilePath = Paths.get(stateLoc, vmName, "Vagrantfile");
        StringBuffer bcontent = new StringBuffer();
        try {
            String defaultContent = new String(Files.readAllBytes(vagrantFilePath), StandardCharsets.UTF_8);
            String[] stringArray = defaultContent.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.contains("config.vm.box")) {
                    String defLine = line.replaceAll("config.vm.box = \".*\"", "config.vm.define :\"" + vmName + "\"");
                    String boxLine = line.replaceAll("config.vm.box = \".*\"", "config.vm.box = \"" + boxName + "\"");
                    bcontent.append(String.valueOf(defLine) + '\n');
                    bcontent.append(String.valueOf(boxLine) + '\n');
                } else {
                    bcontent.append(String.valueOf(line) + '\n');
                }
                ++n2;
            }
            Files.write(vagrantFilePath, bcontent.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vagrantDir;
    }
}

