/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSBasedHover
implements ITextHover,
ITextHoverExtension {
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage());
    private List<CompletableFuture<?>> requests;
    private List<Hover> hoverResults;
    private List<CodeLens> codeLensResults;
    private IRegion lastRegion;
    private ITextViewer textViewer;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        if (!hoverRegion.equals(this.lastRegion) || !textViewer.equals(this.textViewer) || this.requests == null) {
            this.initiateHoverRequest(textViewer, hoverRegion.getOffset());
        }
        try {
            CompletableFuture.allOf(this.requests.toArray(new CompletableFuture[this.requests.size()])).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
        }
        String result = "";
        if (this.hoverResults != null && !this.hoverResults.isEmpty()) {
            result = String.valueOf(result) + this.hoverResults.stream().filter(Objects::nonNull).map(LSBasedHover::getHoverString).filter(Objects::nonNull).collect(Collectors.joining("\n\n"));
        }
        if (this.codeLensResults != null && !this.codeLensResults.isEmpty()) {
            String codeLensResult = this.codeLensResults.stream().filter(Objects::nonNull).map(LSBasedHover::getCodeLensString).filter(Objects::nonNull).collect(Collectors.joining("\n\n"));
            if (!codeLensResult.isEmpty()) {
                result = String.valueOf(result) + "\n\n";
            }
            result = String.valueOf(result) + codeLensResult;
        }
        if (result.isEmpty()) {
            return null;
        }
        result = MARKDOWN_PARSER.parseToHtml(result);
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.HOVER_FOREGROUND");
        Color background = colorRegistry.get("org.eclipse.ui.workbench.HOVER_BACKGROUND");
        String style = "<style TYPE='text/css'>html { font-family: " + JFaceResources.getDefaultFontDescriptor().getFontData()[0].getName() + "; " + "font-size: " + Integer.toString(JFaceResources.getDefaultFontDescriptor().getFontData()[0].getHeight()) + "pt; " + (background != null ? "background-color: " + LSBasedHover.toHTMLrgb(background.getRGB()) + "; " : "") + (foreground != null ? "color: " + LSBasedHover.toHTMLrgb(foreground.getRGB()) + "; " : "") + " }</style>";
        int headIndex = result.indexOf("<head>");
        StringBuilder builder = new StringBuilder(result.length() + style.length());
        builder.append(result.substring(0, headIndex + "<head>".length()));
        builder.append(style);
        builder.append(result.substring(headIndex + "<head>".length()));
        return builder.toString();
    }

    protected static @Nullable String getHoverString(@NonNull Hover hover) {
        List contents = hover.getContents();
        if (contents == null || contents.isEmpty()) {
            return null;
        }
        return contents.stream().map(content -> {
            if (content.isLeft()) {
                return (String)content.getLeft();
            }
            if (content.isRight()) {
                MarkedString markedString = (MarkedString)content.getRight();
                if (markedString.getLanguage() != null && !markedString.getLanguage().isEmpty()) {
                    return String.format("```%s\n%s\n```", markedString.getLanguage(), markedString.getValue());
                }
                return markedString.getValue();
            }
            return "";
        }).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.joining("\n\n"));
    }

    protected static @Nullable String getCodeLensString(@NonNull CodeLens codeLens) {
        Command command = codeLens.getCommand();
        if (command == null || command.getTitle().isEmpty()) {
            return null;
        }
        return command.getTitle();
    }

    private static @NonNull String toHTMLrgb(RGB rgb) {
        StringBuilder builder = new StringBuilder(7);
        builder.append('#');
        LSBasedHover.appendAsHexString(builder, rgb.red);
        LSBasedHover.appendAsHexString(builder, rgb.green);
        LSBasedHover.appendAsHexString(builder, rgb.blue);
        return builder.toString();
    }

    private static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null) {
            return null;
        }
        Region res = null;
        this.initiateHoverRequest(textViewer, offset);
        try {
            CompletableFuture.allOf(this.requests.toArray(new CompletableFuture[this.requests.size()])).get(800L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e1) {
            LanguageServerPlugin.logError(e1);
        }
        IDocument document = textViewer.getDocument();
        if (!this.hoverResults.isEmpty()) {
            res = new Region(0, document.getLength());
            for (Hover hover : this.hoverResults) {
                int rangeOffset = offset;
                int rangeLength = 0;
                if (hover != null && hover.getRange() != null) {
                    try {
                        Range range = hover.getRange();
                        rangeOffset = LSPEclipseUtils.toOffset(range.getStart(), document);
                        rangeLength = LSPEclipseUtils.toOffset(range.getEnd(), document) - rangeOffset;
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                        res = new Region(offset, 1);
                    }
                }
                res = new Region(Math.max(res.getOffset(), rangeOffset), Math.min(res.getLength(), rangeLength));
            }
        } else {
            res = new Region(offset, 1);
        }
        this.lastRegion = res;
        this.textViewer = textViewer;
        return res;
    }

    private void initiateHoverRequest(@NonNull ITextViewer viewer, int offset) {
        this.textViewer = viewer;
        List<@NonNull LanguageServiceAccessor.LSPDocumentInfo> docInfos = LanguageServiceAccessor.getLSPDocumentInfosFor(viewer.getDocument(), capabilities -> Boolean.TRUE.equals(capabilities.getHoverProvider()));
        ArrayList requests = new ArrayList(docInfos.size());
        List hoverResults = Collections.synchronizedList(new ArrayList(docInfos.size()));
        List codeLensResults = Collections.synchronizedList(new ArrayList(docInfos.size()));
        for (LanguageServiceAccessor.LSPDocumentInfo info : docInfos) {
            try {
                CompletableFuture hover = info.getLanguageClient().getTextDocumentService().hover(LSPEclipseUtils.toTextDocumentPosistionParams(info.getFileUri(), offset, info.getDocument()));
                requests.add((CompletableFuture<?>)hover.thenAccept(hoverResults::add));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
            CodeLensParams param = new CodeLensParams(new TextDocumentIdentifier(info.getFileUri().toString()));
            CompletableFuture codeLenses = info.getLanguageClient().getTextDocumentService().codeLens(param);
            try {
                int line = viewer.getDocument().getLineOfOffset(offset);
                int index = offset - viewer.getDocument().getLineOffset(line);
                requests.add((CompletableFuture<?>)codeLenses.thenAccept(r -> {
                    for (CodeLens codeLens : r) {
                        if (codeLens == null || !LSBasedHover.isOffsetInCodeLensRange(codeLens, line, index)) continue;
                        codeLensResults.add(codeLens);
                    }
                }));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        this.requests = requests;
        this.hoverResults = hoverResults;
        this.codeLensResults = codeLensResults;
    }

    private static boolean isOffsetInCodeLensRange(CodeLens codeLens, int line, int index) {
        System.out.println(codeLens.toString());
        Position start = codeLens.getRange().getStart();
        Position end = codeLens.getRange().getEnd();
        return (start.getLine() < line || start.getLine() == line && start.getCharacter() <= index) && (end.getLine() > line || end.getLine() == line && end.getCharacter() >= index);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }

    private static class FocusableBrowserInformationControl
    extends BrowserInformationControl {
        public FocusableBrowserInformationControl(Shell parent) {
            super(parent, "org.eclipse.jface.defaultfont", EditorsUI.getTooltipAffordanceString());
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    BrowserInformationControl res = new BrowserInformationControl(parent, "org.eclipse.jface.defaultfont", true);
                    return res;
                }
            };
        }
    }
}

