/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchSetDetail;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.egit.GerritToGitMapping;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.internal.gerrit.ui.egit.EGitUiUtil;
import org.eclipse.mylyn.internal.gerrit.ui.factories.Messages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewUiUtil;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.ui.spi.factories.AbstractUiFactory;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractPatchSetUiFactory
extends AbstractUiFactory<IReviewItemSet> {
    public AbstractPatchSetUiFactory(String name, IUiContext context, IReviewItemSet object) {
        super(name, context, (Object)object);
    }

    protected PatchSetDetail getPatchSetDetail() {
        return this.getPatchSetDetail((IReviewItemSet)this.getModelObject());
    }

    protected PatchSetDetail getPatchSetDetail(IReviewItemSet set) {
        RemoteEmfConsumer consumer = this.getGerritFactoryProvider().getReviewItemSetFactory().getConsumerForModel((EObject)((IReviewItemSet)this.getModelObject()).getReview(), (Object)set);
        if (consumer.getRemoteObject() == null) {
            try {
                consumer.pull(false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return (PatchSetDetail)consumer.getRemoteObject();
    }

    protected GerritRemoteFactoryProvider getGerritFactoryProvider() {
        return (GerritRemoteFactoryProvider)this.getFactoryProvider();
    }

    protected GerritChange getChange() {
        RemoteEmfConsumer consumer = this.getGerritFactoryProvider().getReviewFactory().getConsumerForModel((EObject)((IReviewItemSet)this.getModelObject()).getReview().getRepository(), (Object)((IReviewItemSet)this.getModelObject()).getReview());
        GerritChange remoteObject = (GerritChange)consumer.getRemoteObject();
        consumer.release();
        return remoteObject;
    }

    protected final String getGerritProject(ChangeDetail changeDetail) {
        return changeDetail.getChange().getProject().get();
    }

    protected final Repository resolveGitRepository() {
        GerritToGitMapping mapper = this.getGitRepository(false);
        Repository gitRepository = null;
        if (mapper != null) {
            try {
                gitRepository = mapper.find();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return gitRepository;
    }

    protected final GerritToGitMapping getGitRepository(boolean displayCloneDialog) {
        ChangeDetailX changeDetail = this.getChange().getChangeDetail();
        GerritConfigX config = GerritCorePlugin.getGerritClient((TaskRepository)this.getTaskRepository()).getGerritConfig();
        GerritToGitMapping mapper = new GerritToGitMapping(this.getTaskRepository(), (GerritConfig)config, this.getGerritProject((ChangeDetail)changeDetail));
        try {
            if (mapper.find() != null) {
                return mapper;
            }
            if (mapper.getGerritProject() != null) {
                int response;
                boolean create;
                if (displayCloneDialog && (create = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AbstractPatchSetUiFactory_Clone_Git_Repository, (String)Messages.AbstractPatchSetUiFactory_Git_repository_not_found_in_workspace)) && (response = EGitUiUtil.openCloneRepositoryWizard(this.getShell(), this.getTaskRepository(), mapper.getGerritProject())) == 0 && mapper.find() != null) {
                    return mapper;
                }
            } else {
                String message = NLS.bind((String)Messages.AbstractPatchSetUiFactory_No_Git_repository_found_for_fetching, (Object)this.getTask().getTaskKey());
                String reason = NLS.bind((String)Messages.AbstractPatchSetUiFactory_No_remote_config_found_with_fetch_URL, (Object)mapper.getGerritHost(), (Object)mapper.getGerritProjectName());
                GerritCorePlugin.logError((String)message, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AbstractPatchSetUiFactory_Gerrit_Fetch_Change_Error, (String)message, (IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", reason));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.gerrit.ui", "Error accessing Git repository", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 7);
        }
        return null;
    }

    protected boolean isAnonymous() {
        return ReviewUiUtil.isAnonymous((IReviewItem)((IReviewItem)this.getModelObject()));
    }

    protected boolean isExecutableStateKnown() {
        return this.isAnonymous() || this.getChange() != null && this.getChange().getChangeDetail() != null && this.getPatchSetDetail() != null;
    }
}

