/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ServiceUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OomphPlugin
extends EMFPlugin {
    protected OomphPlugin(ResourceLocator[] delegateResourceLocators) {
        super(delegateResourceLocators);
    }

    public final boolean isOSGiRunning() {
        return this.getEclipsePlugin() != null;
    }

    protected Plugin getEclipsePlugin() {
        return (Plugin)this.getPluginResourceLocator();
    }

    public final Bundle getBundle() {
        return this.getEclipsePlugin().getBundle();
    }

    public final BundleContext getBundleContext() {
        return this.getBundle().getBundleContext();
    }

    public final List<File> getClassPath() throws Exception {
        Bundle bundle = this.getBundle();
        return OomphPlugin.getClassPath(bundle);
    }

    public final IPath getConfigurationLocation() throws IllegalStateException {
        Location location = Platform.getConfigurationLocation();
        if (location != null) {
            try {
                URL fileURL;
                URL dataArea = location.getDataArea(this.getSymbolicName());
                if (dataArea != null && (fileURL = FileLocator.toFileURL((URL)dataArea)) != null) {
                    return new Path(fileURL.getFile());
                }
            }
            catch (IOException iOException) {}
        }
        throw new IllegalStateException("The configuration location is unavailable");
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return this.getEclipsePlugin().getStateLocation();
    }

    public final IPath getUserLocation() throws IllegalStateException {
        return new Path(PropertiesUtil.getUserHome()).append(".eclipse").append(this.getSymbolicName());
    }

    public final Preferences getInstancePreferences() {
        return this.getPreferences("instance");
    }

    public final Preference getInstancePreference(String key) {
        return new Preference(this.getInstancePreferences(), key);
    }

    public final Preferences getConfigurationPreferences() {
        return this.getPreferences("configuration");
    }

    public final Preference getConfigurationPreference(String key) {
        return new Preference(this.getConfigurationPreferences(), key);
    }

    private Preferences getPreferences(String scope) {
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        Preferences instanceScope = rootNode.node(scope);
        return instanceScope.node(this.getSymbolicName());
    }

    public final boolean isDebugging() {
        return this.getEclipsePlugin().isDebugging();
    }

    public final void setDebugging(boolean value) {
        this.getEclipsePlugin().setDebugging(value);
    }

    public final <T> T getServiceOrNull(Class<T> serviceClass) {
        return ServiceUtil.getServiceOrNull(this.getBundleContext(), serviceClass);
    }

    public final <T> T getService(Class<T> serviceClass) throws ServiceUtil.MissingServiceException {
        return ServiceUtil.getService(this.getBundleContext(), serviceClass);
    }

    public final void ungetService(Object service) {
        ServiceUtil.ungetService(this.getBundleContext(), service);
    }

    public final ILog getLog() {
        Plugin eclipsePlugin = this.getEclipsePlugin();
        if (eclipsePlugin == null) {
            return new ILog(){

                public void removeLogListener(ILogListener listener) {
                }

                public void log(IStatus status) {
                    System.out.println(status);
                }

                public Bundle getBundle() {
                    return null;
                }

                public void addLogListener(ILogListener listener) {
                }
            };
        }
        return eclipsePlugin.getLog();
    }

    public final void log(String message, int severity) {
        this.log((IStatus)new Status(severity, this.getSymbolicName(), message));
    }

    public final void log(String message) {
        this.log(message, 1);
    }

    public final void log(IStatus status) {
        this.getLog().log(status);
    }

    public final void log(Throwable t, int severity) {
        this.log(this.getStatus(t, severity));
    }

    public final String log(Throwable t) {
        IStatus status = this.getStatus(t);
        this.log(status);
        return status.getMessage();
    }

    public final IStatus getStatus(Object obj) {
        if (obj instanceof CoreException) {
            CoreException coreException = (CoreException)obj;
            return coreException.getStatus();
        }
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            return this.getStatus(t, 4);
        }
        return new Status(1, this.getSymbolicName(), obj.toString(), null);
    }

    public final IStatus getStatus(Throwable t, int severity) {
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(severity, this.getSymbolicName(), msg, t);
    }

    public final void coreException(IStatus status) throws CoreException {
        if (status != null) {
            int severity = status.getSeverity();
            if (severity == 8) {
                throw new OperationCanceledException();
            }
            if (severity == 4) {
                throw new CoreException(status);
            }
            if (!status.isOK()) {
                this.log(status);
            }
        }
    }

    public final void coreException(Throwable t) throws CoreException {
        if (t instanceof CoreException) {
            CoreException ex = (CoreException)t;
            IStatus status = ex.getStatus();
            if (status != null && status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            throw ex;
        }
        if (t instanceof OperationCanceledException) {
            throw (OperationCanceledException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        IStatus status = this.getStatus(t);
        throw new CoreException(status);
    }

    public final String getBuildID() {
        Bundle bundle = this.getBundle();
        return OomphPlugin.getBuildID(bundle);
    }

    public final BundleFile getRootFile() {
        return new BundleFile.Root(this.getBundle());
    }

    public final File exportResources(String entry) {
        Bundle bundle = this.getBundle();
        File target = new File(PropertiesUtil.getProperty("java.io.tmpdir"), String.valueOf(bundle.getSymbolicName()) + "_" + bundle.getVersion());
        if (!target.exists()) {
            this.exportResources(entry, target);
        }
        return target;
    }

    public final void exportResources(String entry, File target) {
        Bundle bundle = this.getBundle();
        OomphPlugin.exportResources(bundle, entry, target);
    }

    private static void exportResources(Bundle bundle, String entry, File target) {
        OomphPlugin.exportResources(bundle, entry.length(), entry, String.valueOf(target.getAbsolutePath()) + "/");
    }

    private static void exportResources(Bundle bundle, int sourceRootLength, String entry, String targetRoot) {
        File file = new File(String.valueOf(targetRoot) + entry.substring(sourceRootLength));
        if (entry.endsWith("/")) {
            file.mkdirs();
            String path = entry.substring(0, entry.length() - 1);
            Enumeration entries = bundle.getEntryPaths(path);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    String childEntry = (String)entries.nextElement();
                    OomphPlugin.exportResources(bundle, sourceRootLength, childEntry, targetRoot);
                }
            }
        } else {
            InputStream source = null;
            FileOutputStream target = null;
            try {
                try {
                    URL url = bundle.getResource(entry);
                    source = url.openStream();
                    target = new FileOutputStream(file);
                    IOUtil.copy(source, target);
                }
                catch (IOException ex) {
                    throw new IORuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(source);
                IOUtil.closeSilent(target);
                throw throwable;
            }
            IOUtil.closeSilent(source);
            IOUtil.closeSilent(target);
        }
    }

    public static void checkCancelation(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static String toString(Throwable t) {
        return OomphPlugin.print(t);
    }

    public static String toString(IStatus status) {
        return OomphPlugin.print(status);
    }

    private static String print(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)out, false, "UTF-8");
            OomphPlugin.print(object, null, printStream, 0, 0);
            printStream.close();
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return object.toString();
        }
    }

    private static void print(Object object, StackTraceElement[] extra, PrintStream stream, int level, int more) {
        if (object instanceof IStatus) {
            IStatus status = (IStatus)object;
            OomphPlugin.indent(stream, level);
            int severity = status.getSeverity();
            switch (severity) {
                case 0: {
                    stream.print("OK");
                    break;
                }
                case 4: {
                    stream.print("ERROR");
                    break;
                }
                case 2: {
                    stream.print("WARNING");
                    break;
                }
                case 1: {
                    stream.print("INFO");
                    break;
                }
                case 8: {
                    stream.print("CANCEL");
                    break;
                }
                default: {
                    stream.print("severity=");
                    stream.print(severity);
                }
            }
            stream.print(": ");
            stream.print(status.getPlugin());
            stream.print(" code=");
            stream.print(status.getCode());
            stream.print(' ');
            stream.println(status.getMessage());
            Throwable t = status.getException();
            if (t != null) {
                OomphPlugin.print(t, null, stream, level, more);
            } else if (extra != null) {
                OomphPlugin.print(extra, null, stream, level, more);
            }
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                OomphPlugin.print(child, null, stream, level + 1, more);
                ++n2;
            }
        } else if (object instanceof CoreException) {
            CoreException ex = (CoreException)object;
            IStatus status = ex.getStatus();
            if (status.getException() == null) {
                extra = ex.getStackTrace();
            }
            OomphPlugin.print(status, extra, stream, level, more);
        } else if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            OomphPlugin.indent(stream, level);
            if (more != 0) {
                stream.print("Caused by: ");
            }
            stream.print(t.getClass().getName());
            String msg = t.getLocalizedMessage();
            if (msg != null && msg.length() != 0) {
                stream.print(": ");
                stream.print(msg);
            }
            stream.println();
            OomphPlugin.print(t.getStackTrace(), null, stream, level, more);
            Throwable cause = t.getCause();
            if (cause != null) {
                OomphPlugin.print(cause, null, stream, level, more + 1);
            }
            if (t instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)t).getTargetException();
                OomphPlugin.print(targetException, null, stream, level + 1, more);
            }
        } else if (object instanceof StackTraceElement[]) {
            StackTraceElement[] stackTrace = (StackTraceElement[])object;
            int i = 0;
            while (i < stackTrace.length - more) {
                OomphPlugin.indent(stream, level + 1);
                stream.print("at ");
                stream.println(stackTrace[i].toString());
                ++i;
            }
            if (more != 0) {
                OomphPlugin.indent(stream, level + 1);
                stream.print("... ");
                stream.print(more);
                stream.println(" more");
            }
        } else if (extra != null) {
            OomphPlugin.print(extra, null, stream, level, more);
        }
    }

    private static void indent(PrintStream stream, int level) {
        int i = 0;
        while (i < level) {
            stream.print("  ");
            ++i;
        }
    }

    public static List<File> getClassPath(Bundle bundle) throws Exception {
        final ArrayList<File> cp = new ArrayList<File>();
        final File file = FileLocator.getBundleFile((Bundle)bundle);
        if (file.isFile()) {
            if (file.getName().endsWith(".jar")) {
                cp.add(file);
            }
        } else if (file.isDirectory()) {
            File classpathFile = new File(file, ".classpath");
            if (classpathFile.isFile()) {
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Element rootElement = XMLUtil.loadRootElement(documentBuilder, classpathFile);
                XMLUtil.handleElementsByTagName(rootElement, "classpathentry", new XMLUtil.ElementHandler(){

                    public void handleElement(Element element) throws Exception {
                        if ("output".equals(element.getAttribute("kind"))) {
                            String path = element.getAttribute("path");
                            cp.add(new File(file, path));
                        }
                    }
                });
            } else {
                cp.add(file);
            }
        }
        return cp;
    }

    public static String getBuildID(Bundle bundle) {
        URL url = bundle.getResource("about.mappings");
        if (url != null) {
            InputStream source = null;
            try {
                source = url.openStream();
                Properties properties = new Properties();
                properties.load(source);
                String buildID = (String)properties.get("0");
                if (buildID != null && !buildID.startsWith("$")) {
                    String string = buildID;
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtil.closeSilent(source);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleFile
    implements Comparable<BundleFile> {
        private static final List<BundleFile> NO_CHILDREN = Collections.emptyList();
        private String name;
        private boolean directory;
        private BundleFile parent;
        private List<BundleFile> children;

        protected BundleFile(String name, boolean directory, BundleFile parent) {
            this.name = name;
            this.directory = directory;
            this.parent = parent;
        }

        public Bundle getBundle() {
            return this.parent.getBundle();
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public BundleFile getParent() {
            return this.parent;
        }

        public String getPath() {
            String path = this.parent.getPath();
            if (path.length() != 0) {
                path = String.valueOf(path) + "/";
            }
            return String.valueOf(path) + this.name;
        }

        public List<BundleFile> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<BundleFile>();
                Bundle bundle = this.getBundle();
                String path = "/" + this.getPath();
                Enumeration paths = bundle.getEntryPaths(path);
                while (paths.hasMoreElements()) {
                    String childPath = (String)paths.nextElement();
                    boolean directory = childPath.endsWith("/");
                    String childName = new Path(childPath).removeTrailingSeparator().lastSegment();
                    BundleFile child = new BundleFile(childName, directory, this);
                    this.children.add(child);
                }
                if (this.children.isEmpty()) {
                    this.children = NO_CHILDREN;
                } else {
                    Collections.sort(this.children);
                }
            }
            return this.children;
        }

        public BundleFile getChild(String path) {
            String remainder;
            String name;
            int slash = path.indexOf(47);
            if (slash != -1) {
                name = path.substring(0, slash);
                remainder = path.substring(slash + 1);
            } else {
                name = path;
                remainder = null;
            }
            BundleFile child = null;
            for (BundleFile c : this.getChildren()) {
                if (!c.getName().equals(name)) continue;
                child = c;
                break;
            }
            if (child != null && remainder != null) {
                child = child.getChild(remainder);
            }
            return child;
        }

        public BundleFile addChild(String name, boolean directory) throws IOException {
            this.checkDirectory();
            BundleFile child = this.getChild(name);
            if (child != null) {
                throw new IllegalStateException("File already exists: " + child);
            }
            child = new BundleFile(name, directory, this);
            File file = new File(this.getFile(), name);
            if (directory) {
                file.mkdir();
            } else {
                file.createNewFile();
            }
            List<BundleFile> children = this.getChildren();
            children.add(child);
            Collections.sort(children);
            return child;
        }

        public void export(File target) {
            Bundle bundle = this.getBundle();
            String path = this.getPath();
            if (this.isDirectory()) {
                path = String.valueOf(path) + "/";
            }
            OomphPlugin.exportResources(bundle, path, target);
        }

        public InputStream getContents() {
            this.checkFile();
            String path = this.getPath();
            URL url = this.getBundle().getEntry(path);
            Closeable in = null;
            try {
                InputStream inputStream = url.openStream();
                return inputStream;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                IOUtil.closeSilent(in);
            }
        }

        public String getContentsString() {
            InputStream contents = this.getContents();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtil.copy(contents, out);
            try {
                return out.toString("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setContents(String contents) {
            this.checkFile();
            File file = this.getFile();
            FileOutputStream out = null;
            try {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes("UTF-8"));
                    out = new FileOutputStream(file);
                    IOUtil.copy(in, out);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(out);
                throw throwable;
            }
            IOUtil.closeSilent(out);
        }

        @Override
        public int compareTo(BundleFile o) {
            return this.name.compareTo(o.getName());
        }

        public String toString() {
            return this.getPath();
        }

        private void checkDirectory() {
            if (!this.directory) {
                throw new IllegalStateException("Should not be called on files");
            }
        }

        private void checkFile() {
            if (this.directory) {
                throw new IllegalStateException("Should not be called on directories");
            }
        }

        private File getFile() {
            String path = this.getPath();
            URL url = this.getBundle().getEntry(path);
            try {
                return new File(FileLocator.toFileURL((URL)url).getFile());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private static class Root
        extends BundleFile {
            private Bundle bundle;

            public Root(Bundle bundle) {
                super("", true, null);
                if (bundle == null) {
                    throw new IllegalArgumentException("Bundle is null");
                }
                this.bundle = bundle;
            }

            public Bundle getBundle() {
                return this.bundle;
            }

            public String getPath() {
                return "";
            }
        }
    }

    public static class Preference {
        private final Preferences preferences;
        private final String key;

        public Preference(Preferences preferences, String key) {
            this.preferences = preferences;
            this.key = key;
        }

        public final Preferences preferences() {
            return this.preferences;
        }

        public final String key() {
            return this.key;
        }

        public void remove() {
            this.preferences.remove(this.key);
            this.flush();
        }

        public String get(String def) {
            return this.preferences.get(this.key, def);
        }

        public void set(String value) {
            this.preferences.put(this.key, value);
            this.flush();
        }

        public int get(int def) {
            return this.preferences.getInt(this.key, def);
        }

        public void set(int value) {
            this.preferences.putInt(this.key, value);
            this.flush();
        }

        public long get(long def) {
            return this.preferences.getLong(this.key, def);
        }

        public void set(long value) {
            this.preferences.putLong(this.key, value);
            this.flush();
        }

        public boolean get(boolean def) {
            return this.preferences.getBoolean(this.key, def);
        }

        public void set(boolean value) {
            this.preferences.putBoolean(this.key, value);
            this.flush();
        }

        public float get(float def) {
            return this.preferences.getFloat(this.key, def);
        }

        public void set(float value) {
            this.preferences.putFloat(this.key, value);
            this.flush();
        }

        public double get(double def) {
            return this.preferences.getDouble(this.key, def);
        }

        public void set(double value) {
            this.preferences.putDouble(this.key, value);
            this.flush();
        }

        public byte[] get(byte[] def) {
            return this.preferences.getByteArray(this.key, def);
        }

        public void set(byte[] value) {
            this.preferences.putByteArray(this.key, value);
            this.flush();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[" + this.key + "]";
        }

        private void flush() {
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException ex) {
                UtilPlugin.INSTANCE.log(ex);
            }
        }
    }
}

