/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.papyrus.infra.nattable.manager.table.AbstractNattableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.provider.AbstractNattableCellLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationImageUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class NattableTopLabelProvider
extends AbstractNattableCellLabelProvider {
    protected String getColumnHeaderLabel(ILabelProviderCellContextElementWrapper cell, IConfigRegistry configRegistry) {
        return this.getLabel(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }

    protected String getRowHeaderLabel(ILabelProviderCellContextElementWrapper cell, IConfigRegistry configRegistry) {
        Object representedObjet = cell.getObject();
        if (representedObjet instanceof IAxis && ((IAxis)representedObjet).getElement() instanceof TreeFillingConfiguration) {
            TreeFillingConfiguration conf = (TreeFillingConfiguration)((IAxis)representedObjet).getElement();
            return this.getLabel(cell, configRegistry, conf.getLabelProviderContext());
        }
        return this.getLabel(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }

    @Override
    public String getText(Object element) {
        ILabelProviderCellContextElementWrapper contextElement = (ILabelProviderCellContextElementWrapper)element;
        IConfigRegistry configRegistry = contextElement.getConfigRegistry();
        LabelStack labels = this.getLabelStack(contextElement, configRegistry);
        if (labels.hasLabel("FILTER_ROW")) {
            return this.getBodyLabel(contextElement, configRegistry);
        }
        if (labels.hasLabel("COLUMN_HEADER")) {
            return this.getColumnHeaderLabel(contextElement, configRegistry);
        }
        if (labels.hasLabel("ROW_HEADER")) {
            return this.getRowHeaderLabel(contextElement, configRegistry);
        }
        if (labels.hasLabel("BODY") || labels.hasLabel("FILTER_ROW")) {
            return this.getBodyLabel(contextElement, configRegistry);
        }
        Object value = contextElement.getObject();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected LabelStack getLabelStack(ILabelProviderCellContextElementWrapper contextElement, IConfigRegistry configRegistry) {
        LabelStack labels = contextElement.getConfigLabels();
        if (labels.getLabels().isEmpty()) {
            INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            labels = ((AbstractNattableWidgetManager)manager).getGridLayer().getBodyLayer().getConfigLabelsByPosition(contextElement.getColumnPosition(), contextElement.getRowPosition());
        }
        return labels;
    }

    protected String getLabel(ILabelProviderCellContextElementWrapper contextElement, IConfigRegistry configRegistry, String labelproviderContext) {
        String txt = "";
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider(labelproviderContext, (Object)contextElement);
        txt = labelProvider != null ? labelProvider.getText((Object)contextElement) : ((labelProvider = serv.getLabelProvider(labelproviderContext, contextElement.getObject())) != null ? labelProvider.getText(contextElement.getObject()) : ((labelProvider = serv.getLabelProvider(contextElement.getObject())) != null ? labelProvider.getText(contextElement.getObject()) : contextElement.getObject().toString()));
        return txt;
    }

    protected String getBodyLabel(ILabelProviderCellContextElementWrapper cellWrapperContextElement, IConfigRegistry configRegistry) {
        return this.getLabel(cellWrapperContextElement, configRegistry, "org.eclipse.papyrus.infra.nattable.body.labelprovider");
    }

    @Override
    public boolean accept(Object element) {
        return element instanceof ILabelProviderCellContextElementWrapper;
    }

    @Override
    public Image getImage(Object element) {
        ILabelProviderCellContextElementWrapper contextElement = (ILabelProviderCellContextElementWrapper)element;
        Object object = contextElement.getObject();
        String labelProviderContextId = null;
        IConfigRegistry configRegistry = contextElement.getConfigRegistry();
        if (object instanceof IAxis) {
            if (((IAxis)object).getElement() instanceof TreeFillingConfiguration) {
                TreeFillingConfiguration conf = (TreeFillingConfiguration)((IAxis)object).getElement();
                labelProviderContextId = conf.getLabelProviderContext();
                return this.getImage(contextElement, configRegistry, labelProviderContextId);
            }
            if (((IAxis)object).getManager() == null) {
                return null;
            }
            labelProviderContextId = ((IAxis)object).getManager().getLabelProviderContext();
            if ("org.eclipse.papyrus.infra.nattable.header.labelprovider".equals(labelProviderContextId)) {
                return this.getImageWithDecoration(contextElement, configRegistry, labelProviderContextId);
            }
            return this.getImage(contextElement, configRegistry, labelProviderContextId);
        }
        LabelStack labels = this.getLabelStack(contextElement, configRegistry);
        if (labels.hasLabel("COLUMN_HEADER")) {
            return this.getColumnHeaderImage(contextElement, configRegistry);
        }
        if (labels.hasLabel("ROW_HEADER")) {
            return this.getRowHeaderImage(contextElement, configRegistry);
        }
        if (labels.hasLabel("BODY")) {
            return this.getBodyLabelImage(contextElement, configRegistry);
        }
        return null;
    }

    private Image getBodyLabelImage(ILabelProviderCellContextElementWrapper cell, IConfigRegistry configRegistry) {
        return null;
    }

    private Image getRowHeaderImage(ILabelProviderCellContextElementWrapper cell, IConfigRegistry configRegistry) {
        Object representedObjet = cell.getObject();
        if (representedObjet instanceof IAxis && ((IAxis)representedObjet).getElement() instanceof TreeFillingConfiguration) {
            TreeFillingConfiguration conf = (TreeFillingConfiguration)((IAxis)representedObjet).getElement();
            return this.getImage(cell, configRegistry, conf.getLabelProviderContext());
        }
        return this.getImageWithDecoration(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }

    private Image getImageWithDecoration(ILabelProviderCellContextElementWrapper contextElement, IConfigRegistry configRegistry, String labelproviderContext) {
        List decoration;
        Object representedObject;
        Image im = this.getImage(contextElement, configRegistry, labelproviderContext);
        DecorationService decorationService = (DecorationService)configRegistry.getConfigAttribute(NattableConfigAttributes.DECORATION_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"decoration_service_id"});
        if (decorationService != null && (representedObject = AxisUtils.getRepresentedElement(contextElement.getObject())) != null && (decoration = decorationService.getDecorations(representedObject, true)).size() > 0) {
            return DecorationImageUtils.getDecoratedImage((Image)im, (List)decoration, (Point)DecorationImageUtils.SIZE_16_16);
        }
        return im;
    }

    private Image getImage(ILabelProviderCellContextElementWrapper contextElement, IConfigRegistry configRegistry, String labelproviderContext) {
        Image image = null;
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider(labelproviderContext, (Object)contextElement);
        if (labelProvider != null) {
            image = labelProvider.getImage((Object)contextElement);
        } else {
            Object value = contextElement.getObject();
            labelProvider = serv.getLabelProvider(labelproviderContext, value);
            if (labelProvider != null) {
                image = labelProvider.getImage(value);
            } else {
                labelProvider = serv.getLabelProvider(value);
                if (labelProvider != null) {
                    image = labelProvider.getImage(value);
                }
            }
        }
        return image;
    }

    private Image getColumnHeaderImage(ILabelProviderCellContextElementWrapper cell, IConfigRegistry configRegistry) {
        return this.getImageWithDecoration(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }
}

