/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class VmMethodName
implements IMethodName {
    private static final long serialVersionUID = 688964238062226061L;
    private static Map<String, VmMethodName> index = new MapMaker().weakValues().makeMap();
    public static final IMethodName NULL = VmMethodName.get("L_null.null()V");
    private String identifier;

    public static synchronized VmMethodName get(String vmFullQualifiedTypeName, String vmMethodSignature) {
        return VmMethodName.get(String.valueOf(vmFullQualifiedTypeName) + "." + vmMethodSignature);
    }

    public static VmMethodName rebase(ITypeName vmBaseTypeName, IMethodName vmMethodName) {
        Checks.ensureIsInstanceOf(vmBaseTypeName, VmTypeName.class);
        Checks.ensureIsInstanceOf(vmMethodName, VmMethodName.class);
        return VmMethodName.get(vmBaseTypeName.getIdentifier(), vmMethodName.getSignature());
    }

    public static synchronized VmMethodName get(String vmFullQualifiedMethodName) {
        VmMethodName res = index.get(vmFullQualifiedMethodName);
        if (res == null) {
            if (vmFullQualifiedMethodName.startsWith("< ")) {
                Throws.throwIllegalArgumentException("invalid input: " + vmFullQualifiedMethodName);
            }
            res = new VmMethodName(vmFullQualifiedMethodName);
            index.put(vmFullQualifiedMethodName, res);
        }
        return res;
    }

    @VisibleForTesting
    protected VmMethodName(String vmFullQualifiedMethodName) {
        this.identifier = vmFullQualifiedMethodName;
        this.getDeclaringType();
        this.getParameterTypes();
        this.getReturnType();
    }

    @Override
    public ITypeName getDeclaringType() {
        int bracket = this.identifier.lastIndexOf(40);
        int methodSeperator = this.identifier.lastIndexOf(46, bracket);
        return VmTypeName.get(this.identifier.substring(0, methodSeperator));
    }

    @Override
    public String getDescriptor() {
        int bracket = this.identifier.lastIndexOf(40);
        return this.identifier.substring(bracket);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        int methodSeperator = this.identifier.lastIndexOf(46);
        int argumentsSeperator = this.identifier.lastIndexOf(40);
        return this.identifier.substring(methodSeperator + 1, argumentsSeperator);
    }

    @Override
    public ITypeName[] getParameterTypes() {
        ArrayList<VmTypeName> argTypes = new ArrayList<VmTypeName>();
        int openingBracket = this.identifier.lastIndexOf(40);
        char[] desc = this.identifier.substring(openingBracket + 1).toCharArray();
        int off = 0;
        while (desc[off] != ')') {
            switch (desc[off]) {
                case 'V': {
                    argTypes.add(VmTypeName.VOID);
                    break;
                }
                case 'Z': {
                    argTypes.add(VmTypeName.BOOLEAN);
                    break;
                }
                case 'C': {
                    argTypes.add(VmTypeName.CHAR);
                    break;
                }
                case 'B': {
                    argTypes.add(VmTypeName.BYTE);
                    break;
                }
                case 'S': {
                    argTypes.add(VmTypeName.SHORT);
                    break;
                }
                case 'I': {
                    argTypes.add(VmTypeName.INT);
                    break;
                }
                case 'F': {
                    argTypes.add(VmTypeName.FLOAT);
                    break;
                }
                case 'J': {
                    argTypes.add(VmTypeName.LONG);
                    break;
                }
                case 'D': {
                    argTypes.add(VmTypeName.DOUBLE);
                    break;
                }
                case 'L': {
                    int start = off;
                    do {
                        if (desc[++off] != '<') continue;
                        ++off;
                        int numberOfOpenGenerics = 1;
                        while (numberOfOpenGenerics != 0) {
                            switch (desc[off]) {
                                case '>': {
                                    --numberOfOpenGenerics;
                                    break;
                                }
                                case '<': {
                                    ++numberOfOpenGenerics;
                                }
                            }
                            ++off;
                        }
                    } while (desc[off] != ';');
                    String argumentTypeName = new String(desc, start, off - start);
                    argTypes.add(VmTypeName.get(argumentTypeName));
                    break;
                }
                case '[': {
                    String typeName;
                    int start = off++;
                    while (desc[off] == '[') {
                        ++off;
                    }
                    if (desc[off] == 'L') {
                        ++off;
                        while (desc[off] != ';') {
                            ++off;
                        }
                        typeName = new String(desc, start, off - start);
                        argTypes.add(VmTypeName.get(typeName));
                        break;
                    }
                    typeName = new String(desc, start, off + 1 - start);
                    argTypes.add(VmTypeName.get(typeName));
                }
            }
            ++off;
        }
        return argTypes.toArray(new VmTypeName[argTypes.size()]);
    }

    @Override
    public ITypeName getReturnType() {
        String returnType = StringUtils.substringAfterLast((String)this.identifier, (String)")");
        if (!(returnType = StringUtils.substringBefore((String)returnType, (String)"|")).endsWith(";")) {
            VmTypeName res = VmTypeName.get(returnType);
            Checks.ensureIsTrue(res.isPrimitiveType() || res.isArrayType() && res.getArrayBaseType().isPrimitiveType());
            return res;
        }
        returnType = StringUtils.substring((String)returnType, (int)0, (int)-1);
        return VmTypeName.get(returnType);
    }

    @Override
    public String getSignature() {
        int methodSeparator = this.identifier.lastIndexOf(46);
        return this.identifier.substring(methodSeparator + 1);
    }

    @Override
    public boolean isInit() {
        String name = this.getName();
        return "<init>".equals(name) || "<subtype-init>".equals(name);
    }

    @Override
    public boolean isStaticInit() {
        return "<clinit>".equals(this.getName());
    }

    @Override
    public boolean isSynthetic() {
        return this.getName().contains("$");
    }

    @Override
    public boolean similar(IMethodName other) {
        String s1 = other.getSignature();
        return s1.equals(this.getSignature());
    }

    @Override
    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public boolean isVoid() {
        return this.getReturnType().isVoid();
    }

    @Override
    public int compareTo(IMethodName o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    @Override
    public boolean hasParameters() {
        return this.getParameterTypes().length > 0;
    }
}

