/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessControlService;
import org.eclipse.remote.core.IRemoteProcessTerminalService;
import org.eclipse.remote.internal.core.services.local.LocalProcessBuilder;

public class LocalProcess
implements IRemoteProcessControlService,
IRemoteProcessTerminalService {
    private static int refCount = 0;
    private final IRemoteProcess remoteProcess;
    private final Process localProcess;
    private final PTY pty;
    private int width;
    private int height;
    private InputStream procStdout;
    private InputStream procStderr;
    private Thread stdoutReader;
    private Thread stderrReader;
    private final Thread completedChecker;
    private volatile boolean isCompleted;

    public LocalProcess(IRemoteProcess process) {
        this.remoteProcess = process;
        LocalProcessBuilder builder = (LocalProcessBuilder)process.getProcessBuilder();
        this.localProcess = builder.getProcess();
        this.pty = builder.getPty();
        try {
            if (process.getProcessBuilder().redirectErrorStream()) {
                PipedOutputStream pipedOutput = new PipedOutputStream();
                this.procStderr = new NullInputStream();
                this.procStdout = new PipedInputStream(pipedOutput);
                this.stderrReader = new Thread(new ProcOutputMerger(this.localProcess.getErrorStream(), pipedOutput));
                this.stdoutReader = new Thread(new ProcOutputMerger(this.localProcess.getInputStream(), pipedOutput));
                this.stderrReader.start();
                this.stdoutReader.start();
            } else {
                this.procStderr = this.localProcess.getErrorStream();
                this.procStdout = this.localProcess.getInputStream();
            }
        }
        catch (IOException iOException) {
            this.localProcess.destroy();
        }
        this.completedChecker = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!LocalProcess.this.isCompleted) {
                    try {
                        LocalProcess.this.localProcess.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    LocalProcess.this.isCompleted = true;
                }
            }
        });
        this.completedChecker.start();
    }

    @Override
    public void destroy() {
        this.localProcess.destroy();
    }

    @Override
    public int exitValue() {
        return this.localProcess.exitValue();
    }

    @Override
    public InputStream getErrorStream() {
        return this.procStderr;
    }

    @Override
    public InputStream getInputStream() {
        return this.procStdout;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.localProcess.getOutputStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.localProcess.waitFor();
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public IRemoteProcess getRemoteProcess() {
        return this.remoteProcess;
    }

    @Override
    public void setTerminalSize(int cols, int rows, int pwidth, int pheight) {
        if (this.pty != null && (this.width != cols || this.height != rows)) {
            this.width = cols;
            this.height = rows;
            this.pty.setTerminalSize(this.width, this.height);
        }
    }

    public static class Factory
    implements IRemoteProcess.Service.Factory {
        @Override
        public <T extends IRemoteProcess.Service> T getService(IRemoteProcess remoteProcess, Class<T> service) {
            if (LocalProcess.class.equals(service)) {
                return (T)new LocalProcess(remoteProcess);
            }
            if (IRemoteProcessControlService.class.equals(service)) {
                return (T)remoteProcess.getService(LocalProcess.class);
            }
            if (IRemoteProcessTerminalService.class.equals(service)) {
                return (T)remoteProcess.getService(LocalProcess.class);
            }
            return null;
        }
    }

    public class NullInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }

    private class ProcOutputMerger
    implements Runnable {
        private static final int BUF_SIZE = 8192;
        private final InputStream input;
        private final OutputStream output;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcOutputMerger(InputStream input, OutputStream output) {
            this.input = input;
            OutputStream outputStream = this.output = output;
            synchronized (outputStream) {
                refCount = refCount + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] b = new byte[8192];
            try {
                int len;
                while ((len = this.input.read(b)) > 0) {
                    this.output.write(b, 0, len);
                }
            }
            catch (IOException iOException) {}
            OutputStream outputStream = this.output;
            synchronized (outputStream) {
                int n = refCount - 1;
                refCount = n;
                if (n == 0) {
                    try {
                        this.output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

