/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.util.MiscUtil;

public final class OutlineNodeDeleteActionHandler
extends SapphireActionHandler {
    public static final String ID = "Sapphire.Outline.Delete";

    public OutlineNodeDeleteActionHandler() {
        this.setId(ID);
    }

    @Override
    protected Object run(Presentation context) {
        List<MasterDetailsContentNodePart> nodesToDelete;
        ISapphirePart part = this.getPart();
        if (part instanceof MasterDetailsContentNodePart) {
            nodesToDelete = Collections.singletonList((MasterDetailsContentNodePart)part);
        } else if (part instanceof MasterDetailsEditorPagePart) {
            nodesToDelete = ((MasterDetailsEditorPagePart)part).outline().getSelectedNodes();
        } else {
            throw new IllegalStateException();
        }
        MasterDetailsContentNodePart parent = nodesToDelete.get(0).getParentNode();
        List<MasterDetailsContentNodePart> allSiblingNodes = parent.nodes().visible();
        MasterDetailsContentNodePart selectionPostDelete = MiscUtil.findSelectionPostDelete(allSiblingNodes, nodesToDelete);
        if (selectionPostDelete == null) {
            selectionPostDelete = parent;
        }
        for (MasterDetailsContentNodePart node : nodesToDelete) {
            Element element = node.getModelElement();
            Property elementParent = element.parent();
            if (elementParent.definition() instanceof ListProperty) {
                ((ElementList)elementParent).remove((Object)element);
                continue;
            }
            ElementHandle handle = (ElementHandle)elementParent;
            if (handle.content() != element) continue;
            handle.clear();
        }
        if (selectionPostDelete != null) {
            selectionPostDelete.getContentTree().setSelectedNode(selectionPostDelete);
        }
        return null;
    }
}

