/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.List;
import org.eclipse.sapphire.ui.def.Orientation;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.SplitFormDef;
import org.eclipse.sapphire.ui.forms.SplitFormPart;
import org.eclipse.sapphire.ui.forms.SplitFormSectionPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.SplitFormSectionPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class SplitFormPresentation
extends FormComponentPresentation {
    private SashForm form;
    private List<SplitFormSectionPresentation> children;

    public SplitFormPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public SplitFormPart part() {
        return (SplitFormPart)super.part();
    }

    @Override
    public final void render() {
        SplitFormPart part = this.part();
        SplitFormDef def = part.definition();
        int formMarginLeft = (Integer)def.getMarginLeft().content();
        int formMarginRight = (Integer)def.getMarginRight().content();
        int formMarginTop = (Integer)def.getMarginTop().content();
        int formMarginBottom = (Integer)def.getMarginBottom().content();
        Composite formMarginsComposite = new Composite(this.composite(), 0);
        formMarginsComposite.setLayout((Layout)GridLayoutUtil.glayout(1, formMarginLeft, formMarginRight, formMarginTop, formMarginBottom));
        formMarginsComposite.setLayoutData((Object)GridLayoutUtil.gdhspan(part.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        formMarginsComposite.setBackground(this.resources().color(part.getBackgroundColor()));
        formMarginsComposite.setBackgroundMode(1);
        this.form = new SashForm(formMarginsComposite, (part.orientation() == Orientation.HORIZONTAL ? 256 : 512) | 0x10000);
        this.register((Control)this.form);
        this.form.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.form.setBackground(this.resources().color(part.getBackgroundColor()));
        this.form.setBackgroundMode(1);
        ListFactory childrenListFactory = ListFactory.start();
        for (SplitFormSectionPart section : this.part().children().all()) {
            childrenListFactory.add((Object)section.createPresentation(this, (Composite)this.form));
        }
        this.children = childrenListFactory.result();
        for (SplitFormSectionPresentation child : this.children) {
            child.render();
        }
        int[] weights = new int[this.children.size()];
        int i = 0;
        int n = weights.length;
        while (i < n) {
            weights[i] = this.children.get(i).part().weight();
            ++i;
        }
        this.form.setWeights(weights);
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            Orientation orientation = this.part().orientation();
            for (SplitFormSectionPresentation child : this.children) {
                int weight;
                Point size = child.control().getSize();
                int n = weight = orientation == Orientation.HORIZONTAL ? size.x : size.y;
                if (weight != 0) {
                    child.part().weight(orientation == Orientation.HORIZONTAL ? size.x : size.y);
                }
                child.dispose();
            }
            this.children = null;
        }
        this.form = null;
        super.dispose();
    }
}

