/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEnablementEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.PartFunctionContext;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;

public final class PropertyEditorEnabledFunction
extends Function {
    @Text(value="Context property editor not found.")
    private static LocalizableText contextPropertyEditorNotFound;

    static {
        LocalizableText.init(PropertyEditorEnabledFunction.class);
    }

    public String name() {
        return "Enabled";
    }

    public FunctionResult evaluate(FunctionContext context) {
        PartFunctionContext fc;
        SapphirePart part;
        if (context instanceof PartFunctionContext && (part = (fc = (PartFunctionContext)context).part()) instanceof PropertyEditorPart) {
            final Property property = ((PropertyEditorPart)part).property();
            return new FunctionResult(this, (FunctionContext)fc){
                private Listener listener;

                protected void init() {
                    this.listener = new FilteredListener<PropertyEnablementEvent>(){

                        protected void handleTypedEvent(PropertyEnablementEvent event) {
                            this.refresh();
                        }
                    };
                    property.attach(this.listener);
                }

                protected Object evaluate() {
                    return property.enabled();
                }

                public void dispose() {
                    super.dispose();
                    property.detach(this.listener);
                    this.listener = null;
                }
            };
        }
        throw new FunctionException(contextPropertyEditorNotFound.text());
    }
}

