/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.search;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.core.util.SdkException;

public class JavaProjectsWalker {
    private final String m_taskName;
    private final Collection<String> m_fileExtensions;
    private boolean m_skipOutputLocation;
    private boolean m_skipHiddenPaths;
    private BiPredicate<Path, BasicFileAttributes> m_fileFilter;

    public JavaProjectsWalker(String taskName) {
        this.m_taskName = (String)Validate.notNull((Object)taskName);
        this.m_fileExtensions = new ArrayList<String>();
        this.m_skipOutputLocation = true;
        this.m_skipHiddenPaths = true;
    }

    public void walk(Consumer<WorkspaceFile> visitor, IProgressMonitor monitor) throws CoreException {
        IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        monitor.beginTask(this.taskName(), javaProjects.length);
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject root = iJavaProjectArray[n2];
            IProject p = root.getProject();
            Path outputLocation = this.isSkipOutputLocation() ? new File(p.getLocation().toOSString(), root.getOutputLocation().removeFirstSegments(1).toOSString()).toPath() : null;
            this.searchInFolder(visitor, p.getLocation().toFile().toPath(), Charset.forName(p.getDefaultCharset()), outputLocation, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            ++n2;
        }
    }

    protected void searchInFolder(final Consumer<WorkspaceFile> visitor, Path folder, final Charset charset, final Path outputFolder, final IProgressMonitor monitor) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (dir.equals(outputFolder)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!JavaProjectsWalker.this.hiddenFilterAndCustomFilterAccepted(dir, attrs)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (JavaProjectsWalker.this.allFiltersAccepted(file, attrs)) {
                        visitor.accept(new WorkspaceFile(file, charset));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected boolean hiddenFilterAndCustomFilterAccepted(Path file, BasicFileAttributes attrs) {
        if (this.isSkipHiddenPaths() && JavaProjectsWalker.isHidden(file)) {
            return false;
        }
        return this.fileFilter().map(filter -> filter.test(file, attrs)).orElse(Boolean.TRUE);
    }

    protected boolean allFiltersAccepted(Path file, BasicFileAttributes attrs) {
        if (!this.acceptFileExtension(file)) {
            return false;
        }
        return this.hiddenFilterAndCustomFilterAccepted(file, attrs);
    }

    protected boolean acceptFileExtension(Path file) {
        Path path = file.getFileName();
        if (path == null) {
            return false;
        }
        String fileName = path.toString().toLowerCase();
        for (String extension : this.extensionsAccepted()) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isHidden(Path path) {
        Path fileName = path.getFileName();
        return fileName != null && fileName.toString().startsWith(".");
    }

    public String taskName() {
        return this.m_taskName;
    }

    public boolean isSkipOutputLocation() {
        return this.m_skipOutputLocation;
    }

    public JavaProjectsWalker withSkipOutputLocation(boolean skipOutputLocation) {
        this.m_skipOutputLocation = skipOutputLocation;
        return this;
    }

    public boolean isSkipHiddenPaths() {
        return this.m_skipHiddenPaths;
    }

    public JavaProjectsWalker withSkipHiddenPaths(boolean skipHiddenPaths) {
        this.m_skipHiddenPaths = skipHiddenPaths;
        return this;
    }

    public Optional<BiPredicate<Path, BasicFileAttributes>> fileFilter() {
        return Optional.ofNullable(this.m_fileFilter);
    }

    public JavaProjectsWalker withFilter(BiPredicate<Path, BasicFileAttributes> fileFilter) {
        this.m_fileFilter = fileFilter;
        return this;
    }

    public Collection<String> extensionsAccepted() {
        return Collections.unmodifiableCollection(this.m_fileExtensions);
    }

    public JavaProjectsWalker withExtensionsAccepted(String ... extensions) {
        List<String> l = extensions == null ? null : Arrays.asList(extensions);
        return this.withExtensionsAccepted(l);
    }

    public JavaProjectsWalker withExtensionsAccepted(Collection<String> extensions) {
        this.m_fileExtensions.clear();
        if (extensions != null && !extensions.isEmpty()) {
            for (String e : extensions) {
                if (!StringUtils.isNotBlank((CharSequence)e)) continue;
                this.m_fileExtensions.add(e);
            }
        }
        return this;
    }

    public static class WorkspaceFile {
        private final Path m_file;
        private final Charset m_charset;
        private char[] m_content;
        private Optional<IFile> m_workspaceFile;

        protected WorkspaceFile(Path file, Charset charset) {
            this.m_file = (Path)Validate.notNull((Object)file);
            this.m_charset = (Charset)Validate.notNull((Object)charset);
        }

        public Charset charset() {
            return this.m_charset;
        }

        public Path path() {
            return this.m_file;
        }

        public Optional<IFile> inWorkspace() {
            if (this.m_workspaceFile == null) {
                this.m_workspaceFile = Optional.ofNullable(WorkspaceFile.resolveInWorkspace(this.path()));
            }
            return this.m_workspaceFile;
        }

        protected static IFile resolveInWorkspace(Path file) {
            IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toUri());
            if (workspaceFiles.length < 1) {
                return null;
            }
            IFile workspaceFile = workspaceFiles[0];
            if (!workspaceFile.exists()) {
                return null;
            }
            return workspaceFile;
        }

        public char[] content() {
            if (this.m_content == null) {
                try {
                    this.m_content = this.charset().decode(ByteBuffer.wrap(Files.readAllBytes(this.path()))).array();
                }
                catch (IOException e) {
                    throw new SdkException("Unable to read content of file '" + this.path() + "'.", (Throwable)e);
                }
            }
            return this.m_content;
        }

        public String toString() {
            return String.valueOf(WorkspaceFile.class.getSimpleName()) + ": " + this.path();
        }

        public int hashCode() {
            return this.m_file.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WorkspaceFile other = (WorkspaceFile)obj;
            return this.m_file.equals(other.m_file);
        }
    }
}

