/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public final class WorkspaceUtil {
    private WorkspaceUtil() {
    }

    public static List<IFile> getFilesFromWorkspace(Collection<IProject> projects, String extension) {
        List<IFile> allFiles = new ArrayList<IFile>();
        try {
            allFiles = WorkspaceUtil.getWorkspaceFiles((IResource[])projects.toArray(new IProject[projects.size()]));
        }
        catch (CoreException coreException) {}
        if (extension == null) {
            return allFiles;
        }
        ArrayList<IFile> toRemove = new ArrayList<IFile>();
        for (IFile file : allFiles) {
            if (extension.equals(file.getFileExtension())) continue;
            toRemove.add(file);
        }
        for (IFile file : toRemove) {
            allFiles.remove(file);
        }
        return allFiles;
    }

    private static List<IFile> getWorkspaceFiles(IResource[] resources) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isAccessible()) {
                if (resource instanceof IFile) {
                    files.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    files.addAll(WorkspaceUtil.getWorkspaceFiles(((IContainer)resource).members()));
                }
            }
            ++i;
        }
        return files;
    }
}

