/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.business.api.resource.LoadEMFResource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DraggedObjectTester {
    private Object obj;
    private EObject eObj;
    private boolean alreadyTested;

    public DraggedObjectTester(Object obj) {
        this.obj = obj;
    }

    public boolean isEObject() {
        return this.getEObject() != null;
    }

    public EObject getEObject() {
        if (!this.alreadyTested) {
            this.alreadyTested = true;
            if (this.obj instanceof EObject) {
                this.eObj = (EObject)this.obj;
            } else if (this.obj instanceof IAdaptable) {
                this.eObj = (EObject)((IAdaptable)this.obj).getAdapter(EObject.class);
            }
        }
        return this.eObj;
    }

    public boolean isInSession(Session session) {
        EObject eObject;
        boolean isInSession = false;
        if (session != null && (eObject = this.getEObject()) != null) {
            Resource semanticResource = eObject.eResource();
            isInSession = session.getSemanticResources().contains(semanticResource) || ((DAnalysisSessionEObject)((Object)session)).getControlledResources().contains((Object)semanticResource);
        }
        return isInSession;
    }

    public boolean isWorkspaceResource() {
        return this.obj instanceof IResource;
    }

    public boolean isWorkspaceFile() {
        return this.obj instanceof IFile;
    }

    public boolean isLoadableModel() {
        if (this.isWorkspaceFile()) {
            ResourceSetImpl set = new ResourceSetImpl();
            LoadEMFResource runnable = new LoadEMFResource((ResourceSet)set, (IFile)this.obj);
            runnable.run();
            return runnable.getLoadedResource() != null;
        }
        return false;
    }

    public boolean isDSemanticDecoratorAndTargetIsInSession(Session session) {
        return this.obj instanceof DSemanticDecorator && session != null && SessionManager.INSTANCE.getSession(((DSemanticDecorator)this.obj).getTarget()) == session;
    }
}

