/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sphinx.emf.domain.factory.AbstractResourceSetListenerInstaller;
import org.eclipse.sphinx.emf.internal.metamodel.InternalMetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;

public class ModelDescriptorSynchronizerComplement
extends ResourceSetListenerImpl {
    public ModelDescriptorSynchronizerComplement() {
        super(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4).or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0)));
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        HashSet<Resource> loadedResources = new HashSet<Resource>();
        HashSet<Resource> unloadedResources = new HashSet<Resource>();
        HashSet<Resource> addedResources = new HashSet<Resource>();
        HashSet<Resource> removedResources = new HashSet<Resource>();
        for (Notification notification : event.getNotifications()) {
            Object newValue;
            Object notifier = notification.getNotifier();
            if (notifier instanceof Resource) {
                Resource resource = (Resource)notifier;
                newValue = (Boolean)notification.getNewValue();
                if (((Boolean)newValue).booleanValue()) {
                    if (unloadedResources.contains(resource)) {
                        unloadedResources.remove(resource);
                        continue;
                    }
                    loadedResources.add(resource);
                    continue;
                }
                if (loadedResources.contains(resource)) {
                    loadedResources.remove(resource);
                    continue;
                }
                unloadedResources.add(resource);
                continue;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                ArrayList<Resource> newResources = new ArrayList<Resource>();
                newValue = notification.getNewValue();
                if (newValue instanceof List) {
                    List newResourcesValue = (List)newValue;
                    newResources.addAll(newResourcesValue);
                } else if (newValue instanceof Resource) {
                    newResources.add((Resource)newValue);
                }
                for (Resource newResource : newResources) {
                    if (removedResources.contains(newResource)) {
                        removedResources.remove(newResource);
                        continue;
                    }
                    addedResources.add(newResource);
                }
                continue;
            }
            if (notification.getEventType() != 4 && notification.getEventType() != 6) continue;
            ArrayList<Resource> oldResources = new ArrayList<Resource>();
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof List) {
                List oldResourcesValue = (List)oldValue;
                oldResources.addAll(oldResourcesValue);
            } else if (oldValue instanceof Resource) {
                oldResources.add((Resource)oldValue);
            }
            for (Resource oldResource : oldResources) {
                if (addedResources.contains(oldResource)) {
                    addedResources.remove(oldResource);
                    continue;
                }
                removedResources.add(oldResource);
            }
        }
        loadedResources.addAll(addedResources);
        unloadedResources.addAll(removedResources);
        this.handleModelResourceLoaded(loadedResources);
        this.handleModelResourceUnloaded(unloadedResources);
    }

    private void handleModelResourceLoaded(Collection<Resource> resources) {
        if (!resources.isEmpty()) {
            for (Resource resource : resources) {
                IFile file = EcorePlatformUtil.getFile(resource);
                if (file != null && file.exists()) continue;
                ModelDescriptorRegistry.INSTANCE.addModel(resource);
            }
        }
    }

    private void handleModelResourceUnloaded(Collection<Resource> resources) {
        if (!resources.isEmpty()) {
            IFile file;
            for (Resource resource : resources) {
                file = EcorePlatformUtil.getFile(resource);
                if (EcoreResourceUtil.exists(resource.getURI())) continue;
                InternalMetaModelDescriptorRegistry.INSTANCE.removeCachedDescriptor(file);
            }
            for (Resource resource : resources) {
                file = EcorePlatformUtil.getFile(resource);
                if (file != null && file.exists()) continue;
                ModelDescriptorRegistry.INSTANCE.removeModel(resource);
            }
        }
    }

    public static class ModelDescriptorSynchronizerComplementInstaller
    extends AbstractResourceSetListenerInstaller<ModelDescriptorSynchronizerComplement> {
        public ModelDescriptorSynchronizerComplementInstaller() {
            super(ModelDescriptorSynchronizerComplement.class);
        }
    }
}

