/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryComparator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class RepositoriesSortingActionGroup
extends ActionGroup {
    private Action labelSortingAction;
    private Action locationSortingAction;
    private Action hostSortingAction;
    private Action reverseSortingOrderAction;
    private RepositoryComparator comparator;
    private IPropertyChangeListener comparatorUpdater;
    public static final String CHANGE_COMPARATOR = "changeComparator";
    private static final String REPOSITORIES_SORTING_ACTION_GROUP = "repositoriesSortingActionGroup";

    public RepositoriesSortingActionGroup(Shell shell, IPropertyChangeListener comparatorUpdater) {
        Assert.isNotNull((Object)shell);
        this.comparatorUpdater = comparatorUpdater;
        this.labelSortingAction = new Action(CVSUIMessages.RepositoriesSortingActionGroup_label, 8){

            public void run() {
                if (RepositoriesSortingActionGroup.this.labelSortingAction.isChecked()) {
                    RepositoriesSortingActionGroup.this.setComparatorOrder(0);
                }
            }
        };
        this.locationSortingAction = new Action(CVSUIMessages.RepositoriesSortingActionGroup_location, 8){

            public void run() {
                if (RepositoriesSortingActionGroup.this.locationSortingAction.isChecked()) {
                    RepositoriesSortingActionGroup.this.setComparatorOrder(1);
                }
            }
        };
        this.hostSortingAction = new Action(CVSUIMessages.RepositoriesSortingActionGroup_host, 8){

            public void run() {
                if (RepositoriesSortingActionGroup.this.hostSortingAction.isChecked()) {
                    RepositoriesSortingActionGroup.this.setComparatorOrder(2);
                }
            }
        };
        this.reverseSortingOrderAction = new Action(CVSUIMessages.RepositoriesSortingActionGroup_descending, 2){

            public void run() {
                RepositoriesSortingActionGroup.this.reverseSortingOrder();
            }
        };
    }

    void setComparatorOrder(int orderBy) {
        this.comparator.setOrder(orderBy);
        this.firePropertyChange(this.comparator);
    }

    private void reverseSortingOrder() {
        this.comparator.setAscending(!this.comparator.isAscending());
        this.firePropertyChange(this.comparator);
    }

    private void firePropertyChange(RepositoryComparator newComparator) {
        if (this.comparatorUpdater != null) {
            this.comparatorUpdater.propertyChange(new PropertyChangeEvent((Object)this, CHANGE_COMPARATOR, null, (Object)newComparator));
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menuManager = actionBars.getMenuManager();
        if (menuManager.find("additions") != null) {
            menuManager.insertAfter("additions", (IContributionItem)new Separator(REPOSITORIES_SORTING_ACTION_GROUP));
        } else {
            menuManager.add((IContributionItem)new Separator(REPOSITORIES_SORTING_ACTION_GROUP));
        }
        MenuManager sortSubmenu = new MenuManager(CVSUIMessages.RepositoriesSortingActionGroup_sortBy);
        menuManager.appendToGroup(REPOSITORIES_SORTING_ACTION_GROUP, (IContributionItem)sortSubmenu);
        sortSubmenu.add((IAction)this.labelSortingAction);
        sortSubmenu.add((IAction)this.locationSortingAction);
        sortSubmenu.add((IAction)this.hostSortingAction);
        sortSubmenu.add((IContributionItem)new Separator());
        sortSubmenu.add((IAction)this.reverseSortingOrderAction);
    }

    public void setSelectedComparator(RepositoryComparator selectedComparator) {
        this.comparator = selectedComparator;
        this.labelSortingAction.setChecked(selectedComparator.getOrderBy() == 0);
        this.locationSortingAction.setChecked(selectedComparator.getOrderBy() == 1);
        this.hostSortingAction.setChecked(selectedComparator.getOrderBy() == 2);
        this.reverseSortingOrderAction.setChecked(!selectedComparator.isAscending());
        this.firePropertyChange(this.comparator);
    }
}

