/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import java.io.File;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNEntry;

public class SVNConflictDescriptor {
    public final String path;
    public final Kind conflictKind;
    public final SVNEntry.Kind nodeKind;
    public final String propertyName;
    public final boolean isBinary;
    public final String mimeType;
    public final Action action;
    public final Reason reason;
    public final String basePath;
    public final String remotePath;
    public final String localPath;
    public final String mergedPath;
    public final Operation operation;
    public final SVNConflictVersion srcLeftVersion;
    public final SVNConflictVersion srcRightVersion;

    public SVNConflictDescriptor(String path, Kind conflictKind, SVNEntry.Kind nodeKind, String propertyName, boolean isBinary, String mimeType, Action action, Reason reason, Operation operation, String basePath, String remotePath, String localPath, String mergedPath, SVNConflictVersion srcLeftVersion, SVNConflictVersion srcRightVersion) {
        this.path = path;
        this.conflictKind = conflictKind;
        this.nodeKind = nodeKind;
        this.propertyName = propertyName;
        this.isBinary = isBinary;
        this.mimeType = mimeType;
        this.action = action;
        this.reason = reason;
        this.operation = operation;
        this.basePath = this.path != null && basePath != null && !basePath.startsWith(this.path) ? String.valueOf(new File(this.path).getParent()) + File.separator + basePath : basePath;
        this.remotePath = this.path != null && remotePath != null && !remotePath.startsWith(this.path) ? String.valueOf(new File(this.path).getParent()) + File.separator + remotePath : remotePath;
        this.localPath = this.path != null && localPath != null && !localPath.startsWith(this.path) ? String.valueOf(new File(this.path).getParent()) + File.separator + localPath : localPath;
        this.mergedPath = this.path != null && mergedPath != null && !mergedPath.startsWith(this.path) ? String.valueOf(new File(this.path).getParent()) + File.separator + mergedPath : mergedPath;
        this.srcLeftVersion = srcLeftVersion;
        this.srcRightVersion = srcRightVersion;
    }

    public SVNConflictDescriptor(String path, Action action, Reason reason, Operation operation, SVNConflictVersion srcLeftVersion, SVNConflictVersion srcRightVersion) {
        this(path, Kind.CONTENT, SVNEntry.Kind.NONE, null, false, null, action, reason, operation, null, null, null, null, srcLeftVersion, srcRightVersion);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        MODIFY(0),
        ADD(1),
        DELETE(2),
        REPLACE(3);

        public final int id;

        public static Action fromId(int id) {
            Action[] actionArray = Action.values();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action kind = actionArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid action kind: " + id);
        }

        private Action(int id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CONTENT(0),
        PROPERTIES(1),
        TREE(2);

        public final int id;

        private Kind(int id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        NONE(0),
        UPDATE(1),
        SWITCHED(2),
        MERGE(3);

        public final int id;

        public static Operation fromId(int id) {
            Operation[] operationArray = Operation.values();
            int n = operationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operation kind = operationArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid operation kind: " + id);
        }

        private Operation(int id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        MODIFIED(0),
        OBSTRUCTED(1),
        DELETED(2),
        MISSING(3),
        UNVERSIONED(4),
        ADDED(5),
        REPLACED(6),
        MOVED_AWAY(7),
        MOVED_HERE(8);

        public final int id;

        public static Reason fromId(int id) {
            Reason[] reasonArray = Reason.values();
            int n = reasonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Reason kind = reasonArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid reason kind: " + id);
        }

        private Reason(int id) {
            this.id = id;
        }
    }
}

