/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.browser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.CopyResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.MoveResourcesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.RemoteResourceTransfer;
import org.eclipse.team.svn.ui.RemoteResourceTransferrable;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.panel.common.CommentPanel;
import org.eclipse.team.svn.ui.repository.browser.RepositoryBrowserTableComparator;
import org.eclipse.team.svn.ui.repository.model.IToolTipProvider;
import org.eclipse.team.svn.ui.repository.model.RepositoryBranches;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRoot;
import org.eclipse.team.svn.ui.repository.model.RepositoryTags;
import org.eclipse.team.svn.ui.repository.model.RepositoryTrunk;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class RepositoryBrowserTableViewer
extends TableViewer {
    public static final String FMT_REPOSITORY_RESOURCE = "";
    public static final String FMT_REPOSITORY_FILE = "{lock_owner}{lock_creation_date}{lock_expiration_date}{lock_comment}";
    public static final String FMT_REPOSITORY_FOLDER = "";
    public static final String FMT_REPOSITORY_BRANCHES = "";
    public static final String FMT_REPOSITORY_ROOT = "";
    public static final String FMT_REPOSITORY_TAGS = "";
    public static final String FMT_REPOSITORY_TRUNK = "";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_REVISION = 1;
    public static final int COLUMN_LAST_CHANGE_DATE = 2;
    public static final int COLUMN_LAST_CHANGE_AUTHOR = 3;
    public static final int COLUMN_SIZE = 4;
    public static final int COLUMN_HAS_PROPS = 5;
    public static final int COLUMN_LOCK_OWNER = 6;
    private static final Map<Class<?>, String> class2Format = new HashMap();
    protected static String hasProps;
    protected static String noProps;
    protected static String noAuthor;

    static {
        class2Format.put(RepositoryResource.class, "");
        class2Format.put(RepositoryFile.class, FMT_REPOSITORY_FILE);
        class2Format.put(RepositoryFolder.class, "");
        class2Format.put(RepositoryBranches.class, "");
        class2Format.put(RepositoryRoot.class, "");
        class2Format.put(RepositoryTags.class, "");
        class2Format.put(RepositoryTrunk.class, "");
    }

    public RepositoryBrowserTableViewer(Table contentsTable) {
        super(contentsTable);
    }

    public RepositoryBrowserTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void initialize() {
        noAuthor = SVNMessages.SVNInfo_NoAuthor;
        hasProps = SVNUIMessages.RepositoriesView_Browser_HasProps;
        noProps = SVNUIMessages.RepositoriesView_Browser_NoProps;
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.getTable().setLayoutData((Object)data);
        this.getTable().setLayout((Layout)new TableLayout());
        this.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                String tooltipText = "";
                TableItem item = RepositoryBrowserTableViewer.this.getTable().getItem(new Point(e.x, e.y));
                if (item != null && (data = item.getData()) != null && data instanceof IToolTipProvider) {
                    tooltipText = ((IToolTipProvider)data).getToolTipMessage((String)class2Format.get(data.getClass()));
                }
                RepositoryBrowserTableViewer.this.getTable().setToolTipText(tooltipText);
            }

            public void mouseExit(MouseEvent e) {
                RepositoryBrowserTableViewer.this.getTable().setToolTipText("");
            }
        });
        this.addDragSupport(7, new Transfer[]{RemoteResourceTransfer.getInstance()}, (DragSourceListener)new TransferDragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                if (RemoteResourceTransfer.getInstance().isSupportedType(event.dataType)) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryBrowserTableViewer.this.getSelection();
                    ArrayList<IRepositoryResource> resources = new ArrayList<IRepositoryResource>();
                    Iterator it = selection.iterator();
                    while (it.hasNext()) {
                        resources.add(((RepositoryResource)it.next()).getRepositoryResource());
                    }
                    event.data = new RemoteResourceTransferrable(resources.toArray(new IRepositoryResource[0]), 0);
                }
            }

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RepositoryBrowserTableViewer.this.getSelection();
                boolean canBeDragged = selection.size() > 0;
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    if (it.next() instanceof RepositoryResource) continue;
                    canBeDragged = false;
                }
                event.doit = canBeDragged;
            }

            public Transfer getTransfer() {
                return RemoteResourceTransfer.getInstance();
            }
        });
        this.addDropSupport(3, new Transfer[]{RemoteResourceTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){
            protected int expectedOperation = 2;

            public void dragOperationChanged(DropTargetEvent event) {
                this.expectedOperation = event.detail;
            }

            public void dragEnter(DropTargetEvent event) {
                this.expectedOperation = event.detail;
            }

            public void dragOver(DropTargetEvent event) {
                Table repositoryTable = (Table)((DropTarget)event.widget).getControl();
                TableItem aboveItem = repositoryTable.getItem(repositoryTable.toControl(event.x, event.y));
                if (aboveItem == null) {
                    event.detail = 0;
                    return;
                }
                Object aboveObject = aboveItem.getData();
                if (!(aboveObject instanceof RepositoryResource) || aboveObject instanceof RepositoryFile) {
                    event.detail = 0;
                    return;
                }
                RepositoryResource aboveResource = (RepositoryResource)aboveObject;
                if (aboveResource.getRepositoryResource().getSelectedRevision() != SVNRevision.HEAD) {
                    event.detail = 0;
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)RepositoryBrowserTableViewer.this.getSelection();
                for (RepositoryResource current : selection) {
                    if (aboveResource != current && aboveResource != current.getParent()) continue;
                    event.detail = 0;
                    return;
                }
                event.detail = this.expectedOperation;
            }

            public void drop(DropTargetEvent event) {
                Table repositoryTable = (Table)((DropTarget)event.widget).getControl();
                RepositoryResource aboveResource = (RepositoryResource)repositoryTable.getItem(repositoryTable.toControl(event.x, event.y)).getData();
                CommentPanel commentPanel = new CommentPanel(event.detail == 2 ? SVNUIMessages.MoveToAction_Select_Title : SVNUIMessages.CopyToAction_Select_Title);
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), commentPanel);
                if (dialog.open() == 0) {
                    MoveResourcesOperation mainOp = event.detail == 2 ? new MoveResourcesOperation(aboveResource.getRepositoryResource(), ((RemoteResourceTransferrable)event.data).resources, commentPanel.getMessage(), null) : new CopyResourcesOperation(aboveResource.getRepositoryResource(), ((RemoteResourceTransferrable)event.data).resources, commentPanel.getMessage(), null);
                    CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                    op.add((IActionOperation)mainOp);
                    ArrayList<IRepositoryResource> toRefresh = new ArrayList<IRepositoryResource>();
                    toRefresh.add(aboveResource.getRepositoryResource());
                    if (event.detail == 2) {
                        toRefresh.addAll(Arrays.asList(((RemoteResourceTransferrable)event.data).resources));
                    }
                    op.add((IActionOperation)new RefreshRemoteResourcesOperation(SVNUtility.getCommonParents((IRepositoryResource[])toRefresh.toArray(new IRepositoryResource[0]))), new IActionOperation[]{mainOp});
                    ProgressMonitorUtility.doTaskScheduled((IActionOperation)op);
                }
            }
        });
        RepositoryBrowserTableComparator comparator = new RepositoryBrowserTableComparator((Viewer)this);
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_Name, 0, 16384, true, new ColumnWeightData(18, true));
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_Revision, 0, 131072, true, new ColumnWeightData(9, true));
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_LastChangedAt, 0, 16384, true, new ColumnWeightData(17, true));
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_LastChangedBy, 0, 16384, true, new ColumnWeightData(14, true));
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_Size, 0, 131072, true, new ColumnWeightData(10, true));
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_HasProperties, 0, 16384, true, new ColumnWeightData(12, true));
        this.createColumn(comparator, SVNUIMessages.RepositoriesView_Browser_LockOwner, 0, 16384, true, new ColumnWeightData(13, true));
        this.setComparator(comparator);
        comparator.setColumnNumber(0);
        comparator.setReversed(false);
        this.getTable().setSortDirection(128);
        this.getTable().setSortColumn(this.getTable().getColumn(0));
    }

    protected void createColumn(ColumnedViewerComparator comparator, String name, int style, int alignment, boolean resizable, ColumnWeightData data) {
        TableColumn column = new TableColumn(this.getTable(), style);
        column.setText(name);
        column.setResizable(resizable);
        column.setAlignment(alignment);
        ((TableLayout)this.getTable().getLayout()).addColumnData((ColumnLayoutData)data);
        column.addSelectionListener((SelectionListener)comparator);
    }
}

