/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedThreadQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

@NonNullByDefault
public class KernelMemoryUsageDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfXYDataProvider {
    private final KernelMemoryAnalysisModule fModule;
    private static final String NOT_SELECTED = "-1";

    public static @Nullable KernelMemoryUsageDataProvider create(ITmfTrace trace) {
        KernelMemoryAnalysisModule module = (KernelMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelMemoryAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
        if (module != null) {
            module.schedule();
            return new KernelMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private KernelMemoryUsageDataProvider(ITmfTrace trace, KernelMemoryAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    public @NonNull TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        String selectedThread = NOT_SELECTED;
        if (filter instanceof SelectedThreadQueryFilter) {
            selectedThread = ((SelectedThreadQueryFilter)filter).getSelectedThread();
        }
        long[] xValues = filter.getTimesRequested();
        double[] totalKernelMemoryValues = new double[xValues.length];
        double[] selectedThreadValues = new double[xValues.length];
        int selectedThreadKey = ss.optQuarkAbsolute(new String[]{selectedThread});
        long currentEnd = ss.getCurrentEndTime();
        try {
            int i = 0;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time >= ss.getStartTime() && time <= currentEnd) {
                    List threadQuarkList = ss.getSubAttributes(-1, false);
                    List kernelState = ss.queryFullState(time);
                    for (Integer threadQuark : threadQuarkList) {
                        Object val = ((ITmfStateInterval)kernelState.get(threadQuark)).getValue();
                        long value = KernelMemoryUsageDataProvider.extractValue(val);
                        int n = i;
                        totalKernelMemoryValues[n] = totalKernelMemoryValues[n] + (double)value;
                        if (selectedThreadKey != threadQuark) continue;
                        selectedThreadValues[i] = value;
                    }
                }
                ++i;
            }
            Pair<Double, Double> values = KernelMemoryUsageDataProvider.extractValuesShift(ss, Long.min(filter.getEnd(), currentEnd), selectedThreadKey);
            int i2 = 0;
            while (i2 < xValues.length) {
                int n = i2;
                totalKernelMemoryValues[n] = totalKernelMemoryValues[n] + (Double)values.getFirst();
                int n2 = i2++;
                selectedThreadValues[n2] = selectedThreadValues[n2] + (Double)values.getSecond();
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        String total = Objects.requireNonNull(Messages.KernelMemoryUsageDataProvider_Total);
        ySeries.put((Object)total, (Object)new YModel(total, totalKernelMemoryValues));
        if (selectedThread != NOT_SELECTED) {
            ySeries.put((Object)selectedThread, (Object)new YModel(selectedThread, selectedThreadValues));
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.KernelMemoryUsageDataProvider_title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private static Pair<Double, Double> extractValuesShift(ITmfStateSystem ss, long time, int selectedThreadKey) throws StateSystemDisposedException {
        double totalKernelMemoryValuesShift = 0.0;
        double selectThreadValuesShift = 0.0;
        List kernelState = ss.queryFullState(time);
        List threadQuarkList = ss.getQuarks(new String[]{"*", "lowestMemory"});
        for (Integer threadQuark : threadQuarkList) {
            ITmfStateInterval lowestMemoryInterval = (ITmfStateInterval)kernelState.get(threadQuark);
            Object val = lowestMemoryInterval.getValue();
            long lowestMemoryValue = KernelMemoryUsageDataProvider.extractValue(val);
            totalKernelMemoryValuesShift -= (double)lowestMemoryValue;
            if (threadQuark != selectedThreadKey) continue;
            selectThreadValuesShift = -lowestMemoryValue;
        }
        return new Pair((Object)totalKernelMemoryValuesShift, (Object)selectThreadValuesShift);
    }

    private static long extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }
}

