/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.callstack;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderConfigDialog;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEntry;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackEvent;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.ui.IEditorPart;

public class CallStackView
extends AbstractTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.ui.views.callstack";
    private static final String[] COLUMN_NAMES = new String[]{Messages.CallStackView_FunctionColumn, Messages.CallStackView_DepthColumn, Messages.CallStackView_EntryTimeColumn, Messages.CallStackView_ExitTimeColumn, Messages.CallStackView_DurationColumn};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.CallStackView_ThreadColumn};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final Image PROCESS_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/process_obj.gif");
    private static final Image THREAD_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/thread_obj.gif");
    private static final Image STACKFRAME_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/stckframe_obj.gif");
    private static final String IMPORT_BINARY_ICON_PATH = "icons/obj16/binaries_obj.gif";
    private static final ImageDescriptor SORT_BY_NAME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha.gif");
    private static final ImageDescriptor SORT_BY_NAME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha_rev.gif");
    private static final ImageDescriptor SORT_BY_ID_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num.gif");
    private static final ImageDescriptor SORT_BY_ID_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num_rev.gif");
    private static final ImageDescriptor SORT_BY_TIME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_time.gif");
    private static final ImageDescriptor SORT_BY_TIME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_time_rev.gif");
    private static final String SORT_OPTION_KEY = "sort.option";
    private @NonNull SortOption fSortOption = SortOption.BY_NAME;
    private @NonNull Comparator<ITimeGraphEntry> fThreadComparator = new ThreadNameComparator(false);
    private Action fSortByNameAction;
    private Action fSortByIdAction;
    private Action fSortByTimeAction;
    private final Multimap<ITmfTrace, ISymbolProvider> fSymbolProviders = LinkedHashMultimap.create();
    private Action fNextEventAction;
    private Action fPrevEventAction;
    private Action fNextItemAction;
    private Action fPreviousItemAction;
    private Action fConfigureSymbolsAction;
    private TmfSelectionRangeUpdatedSignal fSavedTimeSyncSignal;
    private TmfWindowRangeUpdatedSignal fSavedRangeSyncSignal;
    private boolean fSyncSelection = false;

    public CallStackView() {
        super(ID, new CallStackPresentationProvider());
        this.getPresentationProvider().setCallStackView(this);
        this.setTreeColumns(COLUMN_NAMES);
        this.setTreeLabelProvider(new CallStackTreeLabelProvider());
        this.setEntryComparator(new CallStackComparator());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterContentProvider(new CallStackFilterContentProvider());
        this.setFilterLabelProvider(new CallStackTreeLabelProvider());
    }

    @Override
    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        this.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                CallStackView.this.synchingToTime(event.getBeginTime());
            }
        });
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                CallStackEntry entry;
                ITimeGraphEntry selection = CallStackView.this.getTimeGraphViewer().getSelection();
                if (selection instanceof CallStackEntry && (entry = (CallStackEntry)selection).getFunctionName().length() > 0) {
                    long entryTime = entry.getFunctionEntryTime();
                    long exitTime = entry.getFunctionExitTime();
                    TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)entryTime), TmfTimestamp.fromNanos((long)exitTime));
                    CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range));
                    CallStackView.this.getTimeGraphViewer().setStartFinishTime(entryTime, exitTime);
                    CallStackView.this.startZoomThread(entryTime, exitTime);
                }
            }
        });
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TimeGraphControl timeGraphControl = CallStackView.this.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object object : ((IStructuredSelection)selection).toList()) {
                        if (!(object instanceof CallStackEvent)) continue;
                        CallStackEvent event = (CallStackEvent)object;
                        long startTime = event.getTime();
                        long endTime = startTime + event.getDuration();
                        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
                        CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range));
                        CallStackView.this.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                        CallStackView.this.startZoomThread(startTime, endTime);
                        break;
                    }
                }
            }
        });
        this.contributeToActionBars();
        this.loadSortOption();
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    @Override
    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        TmfSelectionRangeUpdatedSignal tmfSelectionRangeUpdatedSignal = this.fSavedTimeSyncSignal = this.isPinned() ? new TmfSelectionRangeUpdatedSignal(signal.getSource(), signal.getBeginTime(), signal.getEndTime()) : null;
        if (signal.getSource() == this || this.getTrace() == null || this.isPinned()) {
            return;
        }
        final long beginTime = signal.getBeginTime().toNanos();
        final long endTime = signal.getEndTime().toNanos();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CallStackView.this.getTimeGraphViewer().getControl().isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    CallStackView.this.getTimeGraphViewer().setSelectedTime(beginTime, true);
                } else {
                    CallStackView.this.getTimeGraphViewer().setSelectionRange(beginTime, endTime, true);
                }
                CallStackView.this.fSyncSelection = true;
                CallStackView.this.synchingToTime(beginTime);
                CallStackView.this.fSyncSelection = false;
                CallStackView.this.startZoomThread(CallStackView.this.getTimeGraphViewer().getTime0(), CallStackView.this.getTimeGraphViewer().getTime1());
            }
        });
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (this.isPinned()) {
            this.fSavedRangeSyncSignal = new TmfWindowRangeUpdatedSignal(signal.getSource(), signal.getCurrentRange());
            this.fSavedTimeSyncSignal = null;
        }
        if (signal.getSource() == this || this.isPinned()) {
            return;
        }
        super.windowRangeUpdated(signal);
    }

    @Override
    protected CallStackPresentationProvider getPresentationProvider() {
        return (CallStackPresentationProvider)super.getPresentationProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        Multimap<ITmfTrace, ISymbolProvider> multimap = this.fSymbolProviders;
        synchronized (multimap) {
            for (ITmfTrace trace : this.getTracesToBuild(signal.getTrace())) {
                this.fSymbolProviders.removeAll((Object)trace);
            }
        }
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.updateConfigureSymbolsAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildEntryList(ITmfTrace trace, final ITmfTrace parentTrace, final IProgressMonitor monitor) {
        CallStackAnalysis module;
        if (monitor.isCanceled()) {
            return;
        }
        Collection providers = this.fSymbolProviders.get((Object)trace);
        if (providers.isEmpty()) {
            providers = SymbolProviderManager.getInstance().getSymbolProviders(trace);
            providers.forEach(provider -> provider.loadConfiguration((IProgressMonitor)new NullProgressMonitor()));
            this.fSymbolProviders.putAll((Object)trace, (Iterable)providers);
        }
        if ((module = CallStackView.getCallStackModule(trace)) == null) {
            this.addUnavailableEntry(trace, parentTrace);
            return;
        }
        final ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            this.addUnavailableEntry(trace, parentTrace);
            return;
        }
        HashMap<ITmfTrace, TraceEntry> traceEntryMap = new HashMap<ITmfTrace, TraceEntry>();
        HashMap<Integer, ProcessEntry> processEntryMap = new HashMap<Integer, ProcessEntry>();
        HashMap<Integer, ThreadEntry> threadEntryMap = new HashMap<Integer, ThreadEntry>();
        long start = ss.getStartTime();
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ss.waitUntilBuilt(500L);
            if (ss.isCancelled()) {
                return;
            }
            final long end = ss.getCurrentEndTime();
            if (start == end && !complete) continue;
            TraceEntry traceEntry = (TraceEntry)traceEntryMap.get(trace);
            if (traceEntry == null) {
                traceEntry = new TraceEntry(trace.getName(), start, end + 1L);
                traceEntryMap.put(trace, traceEntry);
                traceEntry.sortChildren(this.fThreadComparator);
                this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
            } else {
                traceEntry.updateEndTime(end);
            }
            try {
                List processQuarks = ss.getQuarks(module.getProcessesPattern());
                List endStates = ss.queryFullState(end);
                Iterator iterator = processQuarks.iterator();
                while (iterator.hasNext()) {
                    int processQuark = (Integer)iterator.next();
                    TimeGraphEntry threadParent = traceEntry;
                    int processId = -1;
                    if (processQuark != -1) {
                        ProcessEntry processEntry = (ProcessEntry)processEntryMap.get(processQuark);
                        if (processEntry == null) {
                            String processName = ss.getAttributeName(processQuark);
                            ITmfStateValue processStateValue = ((ITmfStateInterval)endStates.get(processQuark)).getStateValue();
                            if (processStateValue.getType() == ITmfStateValue.Type.INTEGER) {
                                processId = processStateValue.unboxInt();
                            } else {
                                try {
                                    processId = Integer.parseInt(processName);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            processEntry = new ProcessEntry(processName, processId, start, end);
                            processEntryMap.put(processQuark, processEntry);
                            traceEntry.addChild(processEntry);
                        } else {
                            processEntry.updateEndTime(end);
                        }
                        threadParent = processEntry;
                    }
                    List threadQuarks = ss.getQuarks(processQuark, module.getThreadsPattern());
                    List startStates = null;
                    Iterator iterator2 = threadQuarks.iterator();
                    while (iterator2.hasNext()) {
                        ITmfStateInterval endInterval;
                        int threadQuark = (Integer)iterator2.next();
                        if (monitor.isCanceled()) {
                            return;
                        }
                        String[] callStackPath = module.getCallStackPath();
                        int callStackQuark = ss.getQuarkRelative(threadQuark, callStackPath);
                        String threadName = ss.getAttributeName(threadQuark);
                        long threadEnd = end + 1L;
                        if (callStackQuark >= endStates.size()) {
                            endStates = ss.queryFullState(end);
                        }
                        if ((endInterval = (ITmfStateInterval)endStates.get(callStackQuark)).getStateValue().isNull() && endInterval.getStartTime() != ss.getStartTime()) {
                            threadEnd = endInterval.getStartTime();
                        }
                        TimeGraphEntry callStackParent = threadParent;
                        if (threadQuark != processQuark) {
                            ThreadEntry threadEntry = (ThreadEntry)threadEntryMap.get(threadQuark);
                            if (threadEntry == null) {
                                ITmfStateValue threadStateValue;
                                if (startStates == null || callStackQuark >= startStates.size()) {
                                    startStates = ss.queryFullState(ss.getStartTime());
                                }
                                long threadId = -1L;
                                if (threadQuark >= endStates.size()) {
                                    endStates = ss.queryFullState(end);
                                }
                                if ((threadStateValue = ((ITmfStateInterval)endStates.get(threadQuark)).getStateValue()).getType() == ITmfStateValue.Type.LONG || threadStateValue.getType() == ITmfStateValue.Type.INTEGER) {
                                    threadId = threadStateValue.unboxLong();
                                } else {
                                    try {
                                        threadId = Long.parseLong(threadName);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                long threadStart = start;
                                ITmfStateInterval startInterval = (ITmfStateInterval)startStates.get(callStackQuark);
                                if (startInterval.getStateValue().isNull()) {
                                    threadStart = Math.min(startInterval.getEndTime() + 1L, end + 1L);
                                }
                                threadEntry = new ThreadEntry(threadName, threadId, threadStart, threadEnd);
                                threadEntryMap.put(threadQuark, threadEntry);
                                threadParent.addChild(threadEntry);
                            } else {
                                threadEntry.updateEndTime(threadEnd);
                            }
                            callStackParent = threadEntry;
                        }
                        int level = 1;
                        Iterator iterator3 = ss.getSubAttributes(callStackQuark, false).iterator();
                        while (iterator3.hasNext()) {
                            int stackLevelQuark = (Integer)iterator3.next();
                            if (level > callStackParent.getChildren().size()) {
                                CallStackEntry callStackEntry = new CallStackEntry(threadName, stackLevelQuark, level, processId, trace, ss);
                                callStackParent.addChild(callStackEntry);
                            }
                            ++level;
                        }
                    }
                }
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError("Error querying state system", e);
            }
            catch (StateSystemDisposedException e) {
                // empty catch block
            }
            if (parentTrace == this.getTrace()) {
                CallStackView e = this;
                synchronized (e) {
                    this.setStartTime(this.getStartTime() == -1L ? start : Math.min(this.getStartTime(), start));
                    this.setEndTime(this.getEndTime() == -1L ? end : Math.max(this.getEndTime(), end));
                }
                this.synchingToTime(this.getTimeGraphViewer().getSelectionBegin());
                this.refresh();
            }
            Consumer<TimeGraphEntry> consumer = new Consumer<TimeGraphEntry>(){

                @Override
                public void accept(TimeGraphEntry entry) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (entry instanceof CallStackEntry) {
                        CallStackView.this.buildStatusEvents(parentTrace, (CallStackEntry)entry, monitor, ss.getStartTime(), end);
                        return;
                    }
                    entry.getChildren().forEach(this);
                }
            };
            traceEntry.getChildren().forEach(consumer);
            start = end;
        }
    }

    private void addUnavailableEntry(ITmfTrace trace, ITmfTrace parentTrace) {
        String name = String.valueOf(Messages.CallStackView_StackInfoNotAvailable) + ' ' + '(' + trace.getName() + ')';
        TraceEntry unavailableEntry = new TraceEntry(name, 0L, 0L);
        this.addToEntryList(parentTrace, Collections.singletonList(unavailableEntry));
        if (parentTrace == this.getTrace()) {
            this.refresh();
        }
    }

    private void buildStatusEvents(ITmfTrace trace, CallStackEntry entry, @NonNull IProgressMonitor monitor, long start, long end) {
        ITmfStateSystem ss = entry.getStateSystem();
        long resolution = Math.max(1L, (end - ss.getStartTime()) / (long)this.getDisplayWidth());
        List<ITimeEvent> eventList = this.getEventList(entry, start, end + 1L, resolution, monitor);
        if (eventList != null) {
            entry.setEventList(eventList);
        }
        if (trace == this.getTrace()) {
            this.redraw();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final List<ITimeEvent> getEventList(TimeGraphEntry tgentry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (!(tgentry instanceof CallStackEntry)) {
            return null;
        }
        CallStackEntry entry = (CallStackEntry)tgentry;
        ITmfStateSystem ss = entry.getStateSystem();
        long start = Math.max(startTime, ss.getStartTime());
        long end = Math.min(endTime, ss.getCurrentEndTime() + 1L);
        if (end <= start) {
            return null;
        }
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        ArrayList<TimeEvent> eventList = null;
        try {
            List stackIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)entry.getQuark(), (long)start, (long)(end - 1L), (long)resolution, (IProgressMonitor)monitor);
            eventList = new ArrayList<TimeEvent>(stackIntervals.size());
            long lastEndTime = -1L;
            boolean lastIsNull = false;
            Iterator iterator = stackIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                if (!statusInterval.getStateValue().isNull()) {
                    int modulo = 180;
                    int value = statusInterval.getStateValue().toString().hashCode() % 180 + 180;
                    eventList.add(new CallStackEvent(entry, time, duration, value));
                    lastIsNull = false;
                } else {
                    if (lastEndTime == -1L && isZoomThread) {
                        eventList.add(new NullTimeEvent(entry, time, duration));
                    } else {
                        if (lastEndTime != time && lastIsNull) {
                            eventList.add(new TimeEvent(entry, lastEndTime, time - lastEndTime));
                        }
                        if (time + duration >= endTime && isZoomThread) {
                            eventList.add(new NullTimeEvent(entry, time, duration));
                        }
                    }
                    lastIsNull = true;
                }
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Error querying state system", e);
            return eventList;
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error querying state system", e);
            return eventList;
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }

    @Override
    protected void synchingToTime(final long time) {
        List<TimeGraphEntry> traceEntries = this.getEntryList(this.getTrace());
        final HashMap fullStateMap = new HashMap();
        if (traceEntries == null) {
            return;
        }
        Consumer<TimeGraphEntry> consumer = new Consumer<TimeGraphEntry>(){

            @Override
            public void accept(TimeGraphEntry entry) {
                if (entry instanceof CallStackEntry) {
                    CallStackEntry callStackEntry = (CallStackEntry)entry;
                    ITmfStateSystem ss = callStackEntry.getStateSystem();
                    if (time < ss.getStartTime() || time > ss.getCurrentEndTime()) {
                        return;
                    }
                    ITmfTrace trace = callStackEntry.getTrace();
                    try {
                        ITmfStateValue stackLevelState;
                        int callStackQuark;
                        ITmfStateInterval stackInterval;
                        List<ITmfStateInterval> fullState = this.getFullState(ss);
                        ITmfStateInterval stackLevelInterval = fullState.get(callStackEntry.getQuark());
                        ITmfStateValue nameValue = stackLevelInterval.getStateValue();
                        String name = CallStackView.this.getFunctionName(trace, callStackEntry.getProcessId(), time, nameValue);
                        callStackEntry.setFunctionName(name);
                        if (!name.isEmpty()) {
                            callStackEntry.setFunctionEntryTime(stackLevelInterval.getStartTime());
                            callStackEntry.setFunctionExitTime(stackLevelInterval.getEndTime() + 1L);
                        }
                        if (CallStackView.this.fSyncSelection && time == (stackInterval = fullState.get(callStackQuark = ss.getParentAttributeQuark(callStackEntry.getQuark()))).getStartTime() && ((stackLevelState = stackInterval.getStateValue()).unboxInt() == callStackEntry.getStackLevel() || stackLevelState.isNull())) {
                            CallStackView.this.fSyncSelection = false;
                            Display.getDefault().asyncExec(() -> {
                                CallStackView.this.getTimeGraphViewer().setSelection(callStackEntry, true);
                                CallStackView.this.getTimeGraphViewer().getTimeGraphControl().fireSelectionChanged();
                            });
                        }
                    }
                    catch (StateSystemDisposedException stateSystemDisposedException) {
                        // empty catch block
                    }
                    return;
                }
                entry.getChildren().forEach(this);
            }

            private List<ITmfStateInterval> getFullState(ITmfStateSystem ss) throws StateSystemDisposedException {
                List fullState = (List)fullStateMap.get(ss);
                if (fullState == null) {
                    fullState = ss.queryFullState(time);
                    fullStateMap.put(ss, fullState);
                }
                return fullState;
            }
        };
        traceEntries.forEach(consumer);
        if (Display.getCurrent() != null) {
            this.getTimeGraphViewer().refresh();
        }
    }

    String getFunctionName(ITmfTrace trace, int processId, long timestamp, ITmfStateValue nameValue) {
        long address = Long.MAX_VALUE;
        String name = "";
        try {
            if (nameValue.getType() == ITmfStateValue.Type.STRING) {
                name = nameValue.unboxStr();
                try {
                    address = Long.parseLong(name, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (nameValue.getType() == ITmfStateValue.Type.INTEGER) {
                name = "0x" + Integer.toUnsignedString(nameValue.unboxInt(), 16);
                address = nameValue.unboxInt();
            } else if (nameValue.getType() == ITmfStateValue.Type.LONG) {
                name = "0x" + Long.toUnsignedString(nameValue.unboxLong(), 16);
                address = nameValue.unboxLong();
            }
        }
        catch (StateValueTypeException stateValueTypeException) {
            // empty catch block
        }
        if (address != Long.MAX_VALUE) {
            for (ISymbolProvider provider : this.fSymbolProviders.get((Object)trace)) {
                String symbol = provider.getSymbolText(processId, timestamp, address);
                if (symbol == null) continue;
                name = symbol;
            }
        }
        return name;
    }

    private void makeActions() {
        this.fPreviousItemAction = this.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
        this.fPreviousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
        this.fNextItemAction = this.getTimeGraphViewer().getNextItemAction();
        this.fNextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
        this.fNextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
    }

    private void contributeToActionBars() {
        this.contributePinActionToToolBar();
        this.fPinAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && !CallStackView.this.isPinned()) {
                    if (CallStackView.this.fSavedRangeSyncSignal != null) {
                        CallStackView.this.windowRangeUpdated(CallStackView.this.fSavedRangeSyncSignal);
                        CallStackView.this.fSavedRangeSyncSignal = null;
                    }
                    if (CallStackView.this.fSavedTimeSyncSignal != null) {
                        CallStackView.this.selectionRangeUpdated(CallStackView.this.fSavedTimeSyncSignal);
                        CallStackView.this.fSavedTimeSyncSignal = null;
                    }
                }
            }
        });
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        this.makeActions();
        manager.add((IAction)this.getConfigureSymbolsAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getSortByNameAction());
        manager.add((IAction)this.getSortByIdAction());
        manager.add((IAction)this.getSortByTimeAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getTimeGraphViewer().getShowFilterDialogAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.getPreviousEventAction());
        manager.add((IAction)this.getNextEventAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getTimeGraphViewer().getToggleBookmarkAction());
        manager.add((IAction)this.getTimeGraphViewer().getPreviousMarkerAction());
        manager.add((IAction)this.getTimeGraphViewer().getNextMarkerAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fPreviousItemAction);
        manager.add((IAction)this.fNextItemAction);
        manager.add((IAction)this.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.getTimeGraphViewer().getZoomOutAction());
    }

    @Override
    protected void fillTimeGraphEntryContextMenu(IMenuManager contextMenu) {
        contextMenu.add((IContributionItem)new GroupMarker("group.reorganize"));
        contextMenu.add((IAction)this.getSortByNameAction());
        contextMenu.add((IAction)this.getSortByIdAction());
        contextMenu.add((IAction)this.getSortByTimeAction());
    }

    private Action getNextEventAction() {
        if (this.fNextEventAction == null) {
            this.fNextEventAction = new Action(){

                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof CallStackEntry) {
                        try {
                            CallStackEntry callStackEntry = (CallStackEntry)entry;
                            ITmfStateSystem ss = callStackEntry.getStateSystem();
                            long time = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), viewer.getSelectionBegin()));
                            TimeGraphEntry parentEntry = callStackEntry.getParent();
                            int quark = ss.getParentAttributeQuark(callStackEntry.getQuark());
                            ITmfStateInterval stackInterval = ss.querySingleState(time, quark);
                            long newTime = stackInterval.getEndTime() + 1L;
                            viewer.setSelectedTimeNotify(newTime, true);
                            stackInterval = ss.querySingleState(Math.min(ss.getCurrentEndTime(), newTime), quark);
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            ITimeGraphEntry selectedEntry = parentEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            viewer.setSelection(selectedEntry, true);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                        }
                        catch (StateSystemDisposedException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            };
            this.fNextEventAction.setText(Messages.TmfTimeGraphViewer_NextStateChangeActionNameText);
            this.fNextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextStateChangeActionToolTipText);
            this.fNextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.fNextEventAction;
    }

    private Action getPreviousEventAction() {
        if (this.fPrevEventAction == null) {
            this.fPrevEventAction = new Action(){

                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof CallStackEntry) {
                        try {
                            CallStackEntry callStackEntry = (CallStackEntry)entry;
                            ITmfStateSystem ss = callStackEntry.getStateSystem();
                            long time = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), viewer.getSelectionBegin()));
                            TimeGraphEntry parentEntry = callStackEntry.getParent();
                            int quark = ss.getParentAttributeQuark(callStackEntry.getQuark());
                            ITmfStateInterval stackInterval = ss.querySingleState(time, quark);
                            if (stackInterval.getStartTime() == time && time > ss.getStartTime()) {
                                stackInterval = ss.querySingleState(time - 1L, quark);
                            }
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            ITimeGraphEntry selectedEntry = parentEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            viewer.setSelection(selectedEntry, true);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                        }
                        catch (StateSystemDisposedException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            };
            this.fPrevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousStateChangeActionNameText);
            this.fPrevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousStateChangeActionToolTipText);
            this.fPrevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.fPrevEventAction;
    }

    private static @Nullable CallStackAnalysis getCallStackModule(@NonNull ITmfTrace trace) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class);
        Iterator it = modules.iterator();
        if (!it.hasNext()) {
            return null;
        }
        CallStackAnalysis module = (CallStackAnalysis)it.next();
        module.schedule();
        if (!module.waitForInitialization()) {
            return null;
        }
        return module;
    }

    private Action getSortByNameAction() {
        if (this.fSortByNameAction == null) {
            this.fSortByNameAction = new Action(Messages.CallStackView_SortByThreadName, 2){

                public void run() {
                    if (CallStackView.this.fSortOption == SortOption.BY_NAME) {
                        CallStackView.this.saveSortOption(SortOption.BY_NAME_REV);
                    } else {
                        CallStackView.this.saveSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fSortByNameAction.setToolTipText(Messages.CallStackView_SortByThreadName);
            this.fSortByNameAction.setImageDescriptor(SORT_BY_NAME_ICON);
        }
        return this.fSortByNameAction;
    }

    private Action getSortByIdAction() {
        if (this.fSortByIdAction == null) {
            this.fSortByIdAction = new Action(Messages.CallStackView_SortByThreadId, 2){

                public void run() {
                    if (CallStackView.this.fSortOption == SortOption.BY_ID) {
                        CallStackView.this.saveSortOption(SortOption.BY_ID_REV);
                    } else {
                        CallStackView.this.saveSortOption(SortOption.BY_ID);
                    }
                }
            };
            this.fSortByIdAction.setToolTipText(Messages.CallStackView_SortByThreadId);
            this.fSortByIdAction.setImageDescriptor(SORT_BY_ID_ICON);
        }
        return this.fSortByIdAction;
    }

    private Action getSortByTimeAction() {
        if (this.fSortByTimeAction == null) {
            this.fSortByTimeAction = new Action(Messages.CallStackView_SortByThreadTime, 2){

                public void run() {
                    if (CallStackView.this.fSortOption == SortOption.BY_TIME) {
                        CallStackView.this.saveSortOption(SortOption.BY_TIME_REV);
                    } else {
                        CallStackView.this.saveSortOption(SortOption.BY_TIME);
                    }
                }
            };
            this.fSortByTimeAction.setToolTipText(Messages.CallStackView_SortByThreadTime);
            this.fSortByTimeAction.setImageDescriptor(SORT_BY_TIME_ICON);
        }
        return this.fSortByTimeAction;
    }

    private void loadSortOption() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getClass().getName());
        if (section == null) {
            return;
        }
        String sortOption = section.get(SORT_OPTION_KEY);
        if (sortOption == null) {
            return;
        }
        this.getSortByNameAction().setChecked(false);
        this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_ICON);
        this.getSortByIdAction().setChecked(false);
        this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_ICON);
        this.getSortByTimeAction().setChecked(false);
        this.getSortByTimeAction().setImageDescriptor(SORT_BY_TIME_ICON);
        if (sortOption.equals(SortOption.BY_NAME.name())) {
            this.fSortOption = SortOption.BY_NAME;
            this.fThreadComparator = new ThreadNameComparator(false);
            this.getSortByNameAction().setChecked(true);
        } else if (sortOption.equals(SortOption.BY_NAME_REV.name())) {
            this.fSortOption = SortOption.BY_NAME_REV;
            this.fThreadComparator = new ThreadNameComparator(true);
            this.getSortByNameAction().setChecked(true);
            this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_REV_ICON);
        } else if (sortOption.equals(SortOption.BY_ID.name())) {
            this.fSortOption = SortOption.BY_ID;
            this.fThreadComparator = new ThreadIdComparator(false);
            this.getSortByIdAction().setChecked(true);
        } else if (sortOption.equals(SortOption.BY_ID_REV.name())) {
            this.fSortOption = SortOption.BY_ID_REV;
            this.fThreadComparator = new ThreadIdComparator(true);
            this.getSortByIdAction().setChecked(true);
            this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_REV_ICON);
        } else if (sortOption.equals(SortOption.BY_TIME.name())) {
            this.fSortOption = SortOption.BY_TIME;
            this.fThreadComparator = new ThreadTimeComparator(false);
            this.getSortByTimeAction().setChecked(true);
        } else if (sortOption.equals(SortOption.BY_TIME_REV.name())) {
            this.fSortOption = SortOption.BY_TIME_REV;
            this.fThreadComparator = new ThreadTimeComparator(true);
            this.getSortByTimeAction().setChecked(true);
            this.getSortByTimeAction().setImageDescriptor(SORT_BY_TIME_REV_ICON);
        }
    }

    private void saveSortOption(SortOption sortOption) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getClass().getName());
        if (section == null) {
            section = settings.addNewSection(this.getClass().getName());
        }
        section.put(SORT_OPTION_KEY, sortOption.name());
        this.loadSortOption();
        List<TimeGraphEntry> entryList = this.getEntryList(this.getTrace());
        if (entryList == null) {
            return;
        }
        for (TimeGraphEntry traceEntry : entryList) {
            traceEntry.sortChildren(this.fThreadComparator);
        }
        this.refresh();
    }

    private Action getConfigureSymbolsAction() {
        if (this.fConfigureSymbolsAction != null) {
            return this.fConfigureSymbolsAction;
        }
        this.fConfigureSymbolsAction = new Action(Messages.CallStackView_ConfigureSymbolProvidersText){

            public void run() {
                SymbolProviderConfigDialog dialog = new SymbolProviderConfigDialog(CallStackView.this.getSite().getShell(), CallStackView.this.getProviderPages());
                if (dialog.open() == 0) {
                    CallStackView.this.getPresentationProvider().resetFunctionNames();
                    CallStackView.this.refresh();
                }
            }
        };
        this.fConfigureSymbolsAction.setToolTipText(Messages.CallStackView_ConfigureSymbolProvidersTooltip);
        this.fConfigureSymbolsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(IMPORT_BINARY_ICON_PATH));
        this.fConfigureSymbolsAction.setEnabled(false);
        return this.fConfigureSymbolsAction;
    }

    private ISymbolProviderPreferencePage[] getProviderPages() {
        ArrayList<ISymbolProviderPreferencePage> pages = new ArrayList<ISymbolProviderPreferencePage>();
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            for (ITmfTrace subTrace : this.getTracesToBuild(trace)) {
                for (ISymbolProvider provider : this.fSymbolProviders.get((Object)subTrace)) {
                    org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider provider2;
                    ISymbolProviderPreferencePage page;
                    if (!(provider instanceof org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider) || (page = (provider2 = (org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider)provider).createPreferencePage()) == null) continue;
                    pages.add(page);
                }
            }
        }
        return pages.toArray(new ISymbolProviderPreferencePage[pages.size()]);
    }

    private void updateConfigureSymbolsAction() {
        ISymbolProviderPreferencePage[] providerPages = this.getProviderPages();
        this.getConfigureSymbolsAction().setEnabled(providerPages.length > 0);
    }

    private class CallStackComparator
    implements Comparator<ITimeGraphEntry> {
        private CallStackComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (o1 instanceof ThreadEntry && o2 instanceof ThreadEntry) {
                return CallStackView.this.fThreadComparator.compare(o1, o2);
            }
            if (o1 instanceof ProcessEntry && o2 instanceof ProcessEntry) {
                return Integer.compare(((ProcessEntry)o1).fProcessId, ((ProcessEntry)o2).fProcessId);
            }
            return 0;
        }
    }

    private class CallStackFilterContentProvider
    extends TimeGraphContentProvider {
        private CallStackFilterContentProvider() {
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof TraceEntry) {
                return super.hasChildren(element);
            }
            return false;
        }

        @Override
        public ITimeGraphEntry[] getChildren(Object parentElement) {
            if (parentElement instanceof TraceEntry) {
                return super.getChildren(parentElement);
            }
            return new ITimeGraphEntry[0];
        }
    }

    private static class CallStackTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private CallStackTreeLabelProvider() {
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                CallStackEntry entry;
                if (element instanceof ProcessEntry) {
                    return PROCESS_IMAGE;
                }
                if (element instanceof ThreadEntry) {
                    return THREAD_IMAGE;
                }
                if (element instanceof CallStackEntry && (entry = (CallStackEntry)element).getFunctionName().length() > 0) {
                    return STACKFRAME_IMAGE;
                }
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CallStackEntry) {
                CallStackEntry entry = (CallStackEntry)element;
                if (columnIndex == 0) {
                    return entry.getFunctionName();
                }
                if (columnIndex == 1 && entry.getFunctionName().length() > 0) {
                    int depth = entry.getStackLevel();
                    return Integer.toString(depth);
                }
                if (columnIndex == 2 && entry.getFunctionName().length() > 0) {
                    ITmfTimestamp ts = TmfTimestamp.fromNanos((long)entry.getFunctionEntryTime());
                    return ts.toString();
                }
                if (columnIndex == 3 && entry.getFunctionName().length() > 0) {
                    ITmfTimestamp ts = TmfTimestamp.fromNanos((long)entry.getFunctionExitTime());
                    return ts.toString();
                }
                if (columnIndex == 4 && entry.getFunctionName().length() > 0) {
                    TmfTimestampDelta ts = new TmfTimestampDelta(entry.getFunctionExitTime() - entry.getFunctionEntryTime(), -9);
                    return ts.toString();
                }
            } else if (element instanceof ITimeGraphEntry && columnIndex == 0) {
                return ((ITimeGraphEntry)element).getName();
            }
            return "";
        }
    }

    private static class ProcessEntry
    extends TimeGraphEntry {
        private final int fProcessId;

        public ProcessEntry(String name, int processId, long startTime, long endTime) {
            super(name, startTime, endTime);
            this.fProcessId = processId;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }
    }

    private static enum SortOption {
        BY_NAME,
        BY_NAME_REV,
        BY_ID,
        BY_ID_REV,
        BY_TIME,
        BY_TIME_REV;

    }

    private static class ThreadEntry
    extends TimeGraphEntry {
        private final long fThreadId;

        public ThreadEntry(String name, long threadId, long startTime, long endTime) {
            super(name, startTime, endTime);
            this.fThreadId = threadId;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }

        public long getThreadId() {
            return this.fThreadId;
        }
    }

    private static class ThreadIdComparator
    implements Comparator<ITimeGraphEntry> {
        private boolean reverse;

        public ThreadIdComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (o1 instanceof ThreadEntry && o2 instanceof ThreadEntry) {
                ThreadEntry t1 = (ThreadEntry)o1;
                ThreadEntry t2 = (ThreadEntry)o2;
                return this.reverse ? Long.compare(t2.getThreadId(), t1.getThreadId()) : Long.compare(t1.getThreadId(), t2.getThreadId());
            }
            return 0;
        }
    }

    private static class ThreadNameComparator
    implements Comparator<ITimeGraphEntry> {
        private boolean reverse;

        public ThreadNameComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            return this.reverse ? o2.getName().compareTo(o1.getName()) : o1.getName().compareTo(o2.getName());
        }
    }

    private static class ThreadTimeComparator
    implements Comparator<ITimeGraphEntry> {
        private boolean reverse;

        public ThreadTimeComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            return this.reverse ? Long.compare(o2.getStartTime(), o1.getStartTime()) : Long.compare(o1.getStartTime(), o2.getStartTime());
        }
    }

    private static class TraceEntry
    extends TimeGraphEntry {
        public TraceEntry(String name, long startTime, long endTime) {
            super(name, startTime, endTime);
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }
    }
}

