/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension6;
import org.eclipse.ui.texteditor.TextEditorAction;

final class WordWrapToggleAction
extends TextEditorAction {
    public WordWrapToggleAction(ResourceBundle resourceBundle, String prefix, ITextEditor editor, boolean checked) {
        super(resourceBundle, prefix, editor, 2);
        this.update(checked);
    }

    public void run() {
        boolean newState = false;
        if (this.isWordWrapPossible()) {
            ITextEditorExtension6 ext6 = (ITextEditorExtension6)((Object)this.getTextEditor());
            newState = !ext6.isWordWrapEnabled();
            ext6.setWordWrap(newState);
        }
        this.update(newState);
    }

    private void update(boolean checked) {
        this.setEnabled(this.isWordWrapPossible());
        this.setChecked(checked);
    }

    @Override
    public void update() {
        this.setEnabled(this.isWordWrapPossible());
        this.setChecked(this.isWordWrapEnabled());
    }

    private boolean isWordWrapPossible() {
        return this.getTextEditor() instanceof ITextEditorExtension6;
    }

    private boolean isWordWrapEnabled() {
        if (this.isWordWrapPossible()) {
            return ((ITextEditorExtension6)((Object)this.getTextEditor())).isWordWrapEnabled();
        }
        return false;
    }
}

