/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.analysis;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public final class QueryAnalyzer {
    private IQueryMetaContext metaContext;
    private Table<PQuery, Boolean, Map<Set<Integer>, Set<Integer>>> functionalDependencyGuarantees = HashBasedTable.create();

    public QueryAnalyzer(IQueryMetaContext metaContext) {
        this.metaContext = metaContext;
    }

    public Map<Set<Integer>, Set<Integer>> getProjectedFunctionalDependencies(PQuery query, boolean strict) {
        HashMap dependencies = (HashMap)this.functionalDependencyGuarantees.get((Object)query, (Object)strict);
        if (dependencies == null) {
            dependencies = new HashMap();
            this.functionalDependencyGuarantees.put((Object)query, (Object)strict, dependencies);
            Set<PBody> bodies = query.getDisjunctBodies().getBodies();
            if (bodies.size() == 1) {
                PBody body = bodies.iterator().next();
                HashMap<PVariable, Integer> parameters = new HashMap<PVariable, Integer>();
                for (ExportedParameter exportedParameter : body.getSymbolicParameters()) {
                    parameters.put(exportedParameter.getParameterVariable(), query.getParameters().indexOf(exportedParameter.getPatternParameter()));
                }
                Map internalDependencies = this.getFunctionalDependencies(body.getConstraints(), strict);
                Map projectedDeps = FunctionalDependencyHelper.projectDependencies(internalDependencies, parameters.keySet());
                for (Map.Entry entry : projectedDeps.entrySet()) {
                    HashSet<Integer> left = new HashSet<Integer>();
                    HashSet<Integer> right = new HashSet<Integer>();
                    for (PVariable pVariable : (Set)entry.getKey()) {
                        left.add((Integer)parameters.get(pVariable));
                    }
                    for (PVariable pVariable : (Set)entry.getValue()) {
                        right.add((Integer)parameters.get(pVariable));
                    }
                    dependencies.put(left, right);
                }
            }
            if (!strict) {
                block4: for (PAnnotation annotation : query.getAnnotationsByName("FunctionalDependency")) {
                    Integer position;
                    ParameterReference parameter;
                    HashSet<Integer> lefts = new HashSet<Integer>();
                    HashSet<Integer> rights = new HashSet<Integer>();
                    for (Object object : annotation.getAllValues("forEach")) {
                        parameter = (ParameterReference)object;
                        position = query.getPositionOfParameter(parameter.getName());
                        if (position == null) continue block4;
                        lefts.add(position);
                    }
                    for (Object object : annotation.getAllValues("unique")) {
                        parameter = (ParameterReference)object;
                        position = query.getPositionOfParameter(parameter.getName());
                        if (position == null) continue block4;
                        rights.add(position);
                    }
                    FunctionalDependencyHelper.includeDependency(dependencies, lefts, rights);
                }
            }
        }
        return dependencies;
    }

    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(Set<PConstraint> constraints, boolean strict) {
        HashMap accumulator = new HashMap();
        for (PConstraint pConstraint : constraints) {
            if (pConstraint instanceof PositivePatternCall) {
                PositivePatternCall call = (PositivePatternCall)pConstraint;
                PQuery query = (PQuery)call.getSupplierKey();
                Map<Set<Integer>, Set<Integer>> paramDependencies = this.getProjectedFunctionalDependencies(query, strict);
                for (Map.Entry<Set<Integer>, Set<Integer>> entry : paramDependencies.entrySet()) {
                    HashSet<PVariable> lefts = new HashSet<PVariable>();
                    HashSet<PVariable> rights = new HashSet<PVariable>();
                    for (Integer index : entry.getKey()) {
                        lefts.add(call.getVariableInTuple(index));
                    }
                    for (Integer index : entry.getValue()) {
                        rights.add(call.getVariableInTuple(index));
                    }
                    FunctionalDependencyHelper.includeDependency(accumulator, lefts, rights);
                }
                continue;
            }
            FunctionalDependencyHelper.includeDependencies(accumulator, pConstraint.getFunctionalDependencies(this.metaContext));
        }
        return accumulator;
    }
}

