/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.connector.AbstractRegistrySourceConnector;

public class SpecificationMapSourceConnector
extends AbstractRegistrySourceConnector {
    private static final String DUPLICATE_MESSAGE = "Duplicate FQN %s cannot be added to connector";
    private Map<String, IQuerySpecificationProvider> specificationProviderMap = Maps.newHashMap();

    public SpecificationMapSourceConnector(String identifier, boolean includeInDefaultViews) {
        super(identifier, includeInDefaultViews);
    }

    public SpecificationMapSourceConnector(String identifier, Set<IQuerySpecificationProvider> specificationProviders, boolean includeInDefaultViews) {
        this(identifier, includeInDefaultViews);
        for (IQuerySpecificationProvider provider : specificationProviders) {
            this.addQuerySpecificationProvider(provider);
        }
    }

    public SpecificationMapSourceConnector(String identifier, SpecificationMapSourceConnector connector, boolean includeInDefaultViews) {
        this(identifier, includeInDefaultViews);
        this.specificationProviderMap.putAll(connector.specificationProviderMap);
    }

    public void addQuerySpecificationProvider(IQuerySpecificationProvider provider) {
        Preconditions.checkNotNull((Object)provider, (Object)"Provider must not be null!");
        String fullyQualifiedName = provider.getFullyQualifiedName();
        if (!this.specificationProviderMap.containsKey(fullyQualifiedName)) {
            this.specificationProviderMap.put(fullyQualifiedName, provider);
            for (IConnectorListener listener : this.listeners) {
                listener.querySpecificationAdded(this, provider);
            }
        } else {
            throw new IllegalArgumentException(String.format(DUPLICATE_MESSAGE, fullyQualifiedName));
        }
    }

    public void removeQuerySpecificationProvider(String fullyQualifiedName) {
        Preconditions.checkNotNull((Object)fullyQualifiedName, (Object)"Fully qualified name must not be null!");
        IQuerySpecificationProvider provider = this.specificationProviderMap.remove(fullyQualifiedName);
        if (provider == null) {
            throw new NoSuchElementException(String.format("Connector does not contain specification with FQN %s", fullyQualifiedName));
        }
        for (IConnectorListener listener : this.listeners) {
            listener.querySpecificationRemoved(this, provider);
        }
    }

    public Set<String> getQuerySpecificationFQNs() {
        ImmutableSet fqns = ImmutableSet.copyOf(this.specificationProviderMap.keySet());
        return fqns;
    }

    public boolean hasQuerySpecificationFQN(String fullyQualifiedName) {
        Preconditions.checkNotNull((Object)fullyQualifiedName, (Object)"FQN must not be null!");
        return this.specificationProviderMap.containsKey(fullyQualifiedName);
    }

    @Override
    protected void sendQuerySpecificationsToListener(IConnectorListener listener) {
        for (IQuerySpecificationProvider provider : this.specificationProviderMap.values()) {
            listener.querySpecificationAdded(this, provider);
        }
    }
}

