/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 * @since 1.4
 */
@SuppressWarnings("all")
public class ShowMatchLocationHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final ISelection selection = HandlerUtil.getCurrentSelection(event);
    IWorkbenchSite _activeSite = HandlerUtil.getActiveSite(event);
    IWorkbenchPage _page = _activeSite.getPage();
    final IViewPart resultView = _page.findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      QueryResultView queryResultView = ((QueryResultView) resultView);
      final boolean active = queryResultView.hasActiveEngine();
      boolean _and = false;
      if (!active) {
        _and = false;
      } else {
        _and = (selection instanceof IStructuredSelection);
      }
      if (_and) {
        final IModelConnector connector = queryResultView.getModelConnector();
        boolean _notEquals = (!Objects.equal(connector, null));
        if (_notEquals) {
          final HashSet<EObject> eObjectsInSelection = CollectionLiterals.<EObject>newHashSet();
          Iterator _iterator = ((IStructuredSelection) selection).iterator();
          final Procedure1<Object> _function = new Procedure1<Object>() {
            @Override
            public void apply(final Object it) {
              boolean _matched = false;
              if (!_matched) {
                if (it instanceof IPatternMatch) {
                  _matched=true;
                  Object[] _array = ((IPatternMatch)it).toArray();
                  Iterable<EObject> _filter = Iterables.<EObject>filter(((Iterable<?>)Conversions.doWrapArray(_array)), EObject.class);
                  Iterables.<EObject>addAll(eObjectsInSelection, _filter);
                }
              }
              if (!_matched) {
                if (it instanceof EObject) {
                  _matched=true;
                  eObjectsInSelection.add(((EObject)it));
                }
              }
              if (!_matched) {
              }
            }
          };
          IteratorExtensions.<Object>forEach(_iterator, _function);
          connector.showLocation(((Object[])Conversions.unwrapArray(eObjectsInSelection, Object.class)));
        }
      }
    }
    return null;
  }
}
