/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.scheduler;

import org.eclipse.viatra.transformation.evm.api.ScheduledExecution;
import org.eclipse.viatra.transformation.evm.api.Scheduler;

public class TimedScheduler
extends Scheduler {
    private long interval;
    private volatile boolean interrupted = false;

    protected TimedScheduler(ScheduledExecution execution, long interval) {
        super(execution);
        this.interval = interval;
        new FiringThread().start();
    }

    @Override
    public void dispose() {
        this.interrupted = true;
        super.dispose();
    }

    private class FiringThread
    extends Thread {
        public FiringThread() {
            this.setName("TimedFiringStrategy [interval: " + TimedScheduler.this.interval + "]");
        }

        @Override
        public void run() {
            while (!TimedScheduler.this.interrupted) {
                TimedScheduler.this.schedule();
                try {
                    Thread.sleep(TimedScheduler.this.interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class TimedSchedulerFactory
    implements Scheduler.ISchedulerFactory {
        private long interval;

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public long getInterval() {
            return this.interval;
        }

        @Override
        public Scheduler prepareScheduler(ScheduledExecution execution) {
            return new TimedScheduler(execution, this.interval);
        }

        public TimedSchedulerFactory(long interval) {
            this.interval = interval;
        }
    }
}

